/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ClayMobItemBreakParticles
implements IClientPayload {
    public static final CustomPacketPayload.Type<ClayMobItemBreakParticles> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_mob_item_break_particle"));
    private final int entity;
    private final Item stack;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClayMobItemBreakParticles> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClayMobItemBreakParticles::getEntity, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), ClayMobItemBreakParticles::getItem, ClayMobItemBreakParticles::new);

    public ClayMobItemBreakParticles(int entity, Item stack) {
        this.entity = entity;
        this.stack = stack;
    }

    public int getEntity() {
        return this.entity;
    }

    public Item getItem() {
        return this.stack;
    }

    @NotNull
    public CustomPacketPayload.Type<ClayMobItemBreakParticles> type() {
        return ID;
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Level level = context.player().level();
        Entity entity = level.getEntity(this.getEntity());
        if (entity instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)entity;
            clayMob.spawnItemBreakParticles(this.getItem().getDefaultInstance(), 5);
        }
    }
}

