/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ClaySoldierReviveCooldownPayload
implements IClientPayload {
    public static final CustomPacketPayload.Type<ClaySoldierReviveCooldownPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_revive_map"));
    private final int entity;
    private final ReviveType reviveType;
    private final int cooldown;
    private static final StreamCodec<FriendlyByteBuf, ReviveType> REVIVE_TYPE_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ReviveType>(){

        public ReviveType decode(FriendlyByteBuf byteBuf) {
            return (ReviveType)byteBuf.readEnum(ReviveType.class);
        }

        public void encode(FriendlyByteBuf buf, ReviveType reviveType) {
            buf.writeEnum((Enum)reviveType);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ClaySoldierReviveCooldownPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClaySoldierReviveCooldownPayload::getEntity, REVIVE_TYPE_STREAM_CODEC, ClaySoldierReviveCooldownPayload::getReviveType, (StreamCodec)ByteBufCodecs.VAR_INT, ClaySoldierReviveCooldownPayload::getCooldown, ClaySoldierReviveCooldownPayload::new);

    public ClaySoldierReviveCooldownPayload(int entity, ReviveType reviveType, int cooldown) {
        this.entity = entity;
        this.reviveType = reviveType;
        this.cooldown = cooldown;
    }

    public int getEntity() {
        return this.entity;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public ReviveType getReviveType() {
        return this.reviveType;
    }

    @NotNull
    public CustomPacketPayload.Type<ClaySoldierReviveCooldownPayload> type() {
        return ID;
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Level level = context.player().level();
        Entity entity = level.getEntity(this.getEntity());
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            soldier.setReviveOnCooldown(this.getReviveType(), this.getCooldown());
        }
    }
}

