/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public final class ClayTeamPlayerDataPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, Single> STREAM_CODEC_SINGLE = StreamCodec.composite(TeamLoyaltyManger.STREAM_CODEC_TEAM_PLAYER, Single::getPair, Single::create);
    public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC_REMOVE = ResourceLocation.STREAM_CODEC.map(Remove::new, Remove::teamId).cast();
    public static final StreamCodec<RegistryFriendlyByteBuf, Creation> STREAM_CODEC_CREATION = StreamCodec.composite(TeamLoyaltyManger.STREAM_CODEC_TEAM_PLAYER_DATA, Creation::data, (StreamCodec)ByteBufCodecs.BOOL, Creation::reload, Creation::new);

    public record Creation(List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> data, boolean reload) implements IClientPayload
    {
        public static final CustomPacketPayload.Type<Creation> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_team_player_data_create"));

        public CustomPacketPayload.Type<Creation> type() {
            return ID;
        }

        @Override
        public void handleClient(INetworkManger.PayloadContext context) {
            TeamLoyaltyManger.createClientTeamPlayerData(this.data, this.reload);
        }
    }

    public record Remove(ResourceLocation teamId) implements IClientPayload
    {
        public static final CustomPacketPayload.Type<Remove> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_team_player_data_remove"));

        public CustomPacketPayload.Type<Remove> type() {
            return ID;
        }

        @Override
        public void handleClient(INetworkManger.PayloadContext context) {
            TeamLoyaltyManger.removeClientTeamPlayerData(this.teamId);
        }
    }

    public record Single(ResourceLocation teamId, TeamPlayerData.PlayerData player) implements IClientPayload
    {
        public static final CustomPacketPayload.Type<Single> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_team_player_data_single"));

        private static Single create(Pair<ResourceLocation, TeamPlayerData.PlayerData> pair) {
            return new Single((ResourceLocation)pair.getFirst(), (TeamPlayerData.PlayerData)pair.getSecond());
        }

        private Pair<ResourceLocation, TeamPlayerData.PlayerData> getPair() {
            return Pair.of((Object)this.teamId, (Object)this.player);
        }

        public CustomPacketPayload.Type<Single> type() {
            return ID;
        }

        @Override
        public void handleClient(INetworkManger.PayloadContext context) {
            TeamLoyaltyManger.updateClientTeamPlayerData(this.teamId, this.player);
        }
    }
}

