/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class SoldierCarriedChangePayload
implements IClientPayload {
    public static final CustomPacketPayload.Type<SoldierCarriedChangePayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_carried_change"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoldierCarriedChangePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SoldierCarriedChangePayload::getEntity, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), SoldierCarriedChangePayload::getItem, SoldierCarriedChangePayload::new);
    private final int entity;
    private final Holder<Item> item;

    public SoldierCarriedChangePayload(int pEntity, Holder<Item> stack) {
        this.entity = pEntity;
        this.item = stack;
    }

    public Holder<Item> getItem() {
        return this.item;
    }

    public int getEntity() {
        return this.entity;
    }

    @NotNull
    public CustomPacketPayload.Type<SoldierCarriedChangePayload> type() {
        return ID;
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Entity entity = context.player().level().getEntity(this.getEntity());
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity claySoldier = (AbstractClaySoldierEntity)entity;
            claySoldier.setCarriedStack(((Item)this.item.value()).getDefaultInstance());
        }
    }
}

