/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking.spawnpayloads;

import java.util.Objects;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public final class ClayBossSpawnPayload
implements IClientPayload {
    public static final CustomPacketPayload.Type<ClayBossSpawnPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_boss_spawn"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClayBossSpawnPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClayBossSpawnPayload::entity, SoldierPropertyMap.STREAM_CODEC, ClayBossSpawnPayload::baseProperties, (StreamCodec)ByteBufCodecs.registry(ModRegistries.BOSS_CLAY_SOLDIER_BEHAVIOURS), s -> s.bossAI, ClayBossSpawnPayload::new);
    private final int entity;
    private final SoldierPropertyMap baseProperties;
    private final BossClaySoldierBehaviour bossAI;

    private ClayBossSpawnPayload(int entity, SoldierPropertyMap baseProperties, BossClaySoldierBehaviour bossAI) {
        this.entity = entity;
        this.baseProperties = baseProperties;
        this.bossAI = bossAI;
    }

    public ClayBossSpawnPayload(BossClaySoldierEntity boss) {
        this(boss.getId(), boss.getBaseProperties(), boss.getBossAI());
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Entity entity = context.client().level.getEntity(this.entity);
        if (entity instanceof BossClaySoldierEntity) {
            BossClaySoldierEntity boss = (BossClaySoldierEntity)entity;
            boss.setBossAI(this.bossAI);
            boss.setBaseProperties(this.baseProperties);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public int entity() {
        return this.entity;
    }

    public SoldierPropertyMap baseProperties() {
        return this.baseProperties;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClayBossSpawnPayload that = (ClayBossSpawnPayload)obj;
        return this.entity == that.entity && Objects.equals(this.baseProperties, that.baseProperties);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.baseProperties);
    }

    public String toString() {
        return "ClayBossSpawnPayload[baseProperties: %s, bossAI: %s]".formatted(this.baseProperties, this.bossAI);
    }
}

