/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking.spawnpayloads;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ClayMobSpawnPayload
implements IClientPayload {
    public static final CustomPacketPayload.Type<ClayMobSpawnPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_mob_spawn"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClayMobSpawnPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClayMobSpawnPayload::getEntity, (StreamCodec)ResourceLocation.STREAM_CODEC, ClayMobSpawnPayload::getTeamId, ClayMobSpawnPayload::new);
    private final int entity;
    private final ResourceLocation teamId;

    public ClayMobSpawnPayload(ClayMobEntity entity) {
        this(entity.getId(), entity.getClayTeamType());
    }

    public ClayMobSpawnPayload(int entity, ResourceLocation teamId) {
        this.entity = entity;
        this.teamId = teamId;
    }

    protected int getEntity() {
        return this.entity;
    }

    protected ResourceLocation getTeamId() {
        return this.teamId;
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Entity entity = context.client().level.getEntity(this.entity);
        if (entity instanceof ClayMobEntity) {
            ClayMobEntity clayMobEntity = (ClayMobEntity)entity;
            clayMobEntity.setClayTeamType(this.teamId);
        }
    }

    public CustomPacketPayload.Type<? extends ClayMobSpawnPayload> type() {
        return ID;
    }
}

