/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking.spawnpayloads;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class ClaySoldierSpawnPayload
implements IClientPayload {
    public static final CustomPacketPayload.Type<ClaySoldierSpawnPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_spawn"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClaySoldierSpawnPayload> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClaySoldierSpawnPayload>(){

        public ClaySoldierSpawnPayload decode(RegistryFriendlyByteBuf buffer) {
            return new ClaySoldierSpawnPayload((Integer)ByteBufCodecs.INT.decode((Object)buffer), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), (List)ReviveType.INT_LIST_STREAM_CODEC.decode((Object)buffer), buffer.readInt(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), buffer.readByte());
        }

        public void encode(RegistryFriendlyByteBuf buffer, ClaySoldierSpawnPayload payload) {
            ByteBufCodecs.INT.encode((Object)buffer, (Object)payload.getEntityId());
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)payload.getTeamId());
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)payload.cape);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)payload.backpack1);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)payload.backpack2);
            ReviveType.INT_LIST_STREAM_CODEC.encode((Object)buffer, payload.reviveCooldowns);
            buffer.writeInt(payload.skinId);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)payload.carried);
            buffer.writeByte(payload.workStatus);
        }
    };
    private final int entityId;
    private final ResourceLocation teamId;
    private final ItemStack cape;
    private final ItemStack backpack1;
    private final ItemStack backpack2;
    private final List<Integer> reviveCooldowns;
    private final int skinId;
    private final ItemStack carried;
    private final byte workStatus;

    protected ClaySoldierSpawnPayload(int entity, ResourceLocation teamId, ItemStack cape, ItemStack backpack1, ItemStack backpack2, List<Integer> reviveCooldowns, int skinId, ItemStack carried, byte workStatus) {
        this.entityId = entity;
        this.teamId = teamId;
        this.cape = cape;
        this.backpack1 = backpack1;
        this.backpack2 = backpack2;
        this.reviveCooldowns = reviveCooldowns;
        this.skinId = skinId;
        this.carried = carried;
        this.workStatus = workStatus;
    }

    public ClaySoldierSpawnPayload(AbstractClaySoldierEntity claySoldier) {
        this.entityId = claySoldier.getId();
        this.teamId = claySoldier.getClayTeamType();
        this.cape = claySoldier.getItemBySlot(SoldierEquipmentSlot.CAPE).stack();
        this.backpack1 = claySoldier.getItemBySlot(SoldierEquipmentSlot.BACKPACK).stack();
        this.backpack2 = claySoldier.getItemBySlot(SoldierEquipmentSlot.BACKPACK_PASSIVE).stack();
        ArrayList<Integer> cooldowns = new ArrayList<Integer>(ReviveType.values().length);
        for (ReviveType type : ReviveType.values()) {
            cooldowns.add(Objects.requireNonNullElse(claySoldier.getReviveTypeCooldown().get(type), -1));
        }
        this.reviveCooldowns = cooldowns;
        this.skinId = claySoldier.getSkinVariant();
        this.carried = claySoldier.getCarriedStack();
        this.workStatus = claySoldier.getDataWorkStatus();
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        Entity entity = context.client().level.getEntity(this.entityId);
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            soldier.handleSpawnPayload(this);
        }
    }

    public ItemStack getCape() {
        return this.cape;
    }

    public ItemStack getBackpack1() {
        return this.backpack1;
    }

    public ItemStack getBackpack2() {
        return this.backpack2;
    }

    public List<Integer> getReviveCooldowns() {
        return this.reviveCooldowns;
    }

    public int getSkinId() {
        return this.skinId;
    }

    public ItemStack getCarried() {
        return this.carried;
    }

    public byte getWorkStatus() {
        return this.workStatus;
    }

    protected int getEntityId() {
        return this.entityId;
    }

    protected ResourceLocation getTeamId() {
        return this.teamId;
    }

    public CustomPacketPayload.Type<? extends ClaySoldierSpawnPayload> type() {
        return ID;
    }
}

