/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform.services;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.capability.CustomEquipCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractCapabilityManger
extends SimpleJsonResourceReloadListener {
    public static final String PATH = "clay_soldiers";
    public static final String FILE_NAME = "capabilities";
    private static final EnumMap<Types, Map<Item, EnabledHolder>> ENABLED_MAP = new EnumMap(Types.class);
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final Codec<Boolean> ENABLED_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.equals("enabled")) {
            return DataResult.success((Object)true);
        }
        if (s.equals("disabled")) {
            return DataResult.success((Object)false);
        }
        return DataResult.error(() -> "Cannot parse %s as enabled/disabled".formatted(s));
    }, b -> b != false ? "enabled" : "disabled");
    private static final Decoder<Map<Types, Map<Item, Boolean>>> DECODER = Codec.unboundedMap(Types.CODEC, (Codec)Codec.unboundedMap((Codec)BuiltInRegistries.ITEM.byNameCodec(), ENABLED_CODEC));

    protected AbstractCapabilityManger() {
        super(new Gson(), PATH);
    }

    @Nullable
    public BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability> getCustomEquip(ItemStack stack) {
        return this.ifEnabledOrNull(Types.EQUIP, stack, CustomEquipCapability.CUSTOM_EQUIP_MAP.get(stack.getItem()));
    }

    @Nullable
    public @Nullable BiFunction<ItemStack, @Nullable SoldierHoldableEffect, ThrowableItemCapability> getThrowableItem(ItemStack stack) {
        return this.ifEnabledOrNull(Types.THROW, stack, ThrowableItemCapability.THROWABLE_ITEM_MAP.get(stack.getItem()));
    }

    public abstract IHamsterWheelEnergyStorage createEnergyStorage(HamsterWheelBlockEntity var1);

    @Nullable
    private <T> T ifEnabledOrNull(Types type, ItemStack stack, T cap) {
        return (T)(Objects.requireNonNullElse(ENABLED_MAP.get((Object)type).get(stack.getItem()), new EnabledHolder()).isEnabled() ? cap : null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ENABLED_MAP.forEach((type, status) -> {
            builder.append(type.serializedName);
            builder.append("{ Enabled: ");
            builder.append(status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isEnabled()).map(Map.Entry::getKey).toList());
            builder.append(", Disabled: ");
            builder.append(status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isDisabled()).map(Map.Entry::getKey).toList());
            builder.append("} ");
        });
        return builder.toString();
    }

    public abstract IBlockCache<IBlockStorageAccess> create(ServerLevel var1, BlockPos var2);

    public abstract IBlockCache<BlueprintRequestHandler> createBlueprint(ServerLevel var1, BlockPos var2);

    public abstract IBlockCache<AssignablePoiCapability> createPoiCache(ServerLevel var1, BlockPos var2);

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        AbstractCapabilityManger.registerCapabilities();
        jsonElementMap.forEach((path, jsonElement) -> {
            if (path.getPath().equals(FILE_NAME)) {
                DECODER.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).ifSuccess(AbstractCapabilityManger::updateCapabilityStatus).ifError(err -> LOGGER.error(err.message()));
            }
        });
        AbstractCapabilityManger.finalizeCapStatuses(false);
    }

    public static void setForClient(Map<Types, Map<Item, Boolean>> map) {
        ENABLED_MAP.putAll(Map.of(Types.THROW, new HashMap(), Types.EQUIP, new HashMap()));
        map.forEach((types, itemBooleanMap) -> {
            Map<Item, EnabledHolder> typeMap = ENABLED_MAP.get(types);
            itemBooleanMap.forEach((item, enabled) -> typeMap.put((Item)item, EnabledHolder.createImmutable(enabled)));
        });
        AbstractCapabilityManger.finalizeCapStatuses(true);
    }

    private static void finalizeCapStatuses(boolean client) {
        ENABLED_MAP.forEach((type, status) -> {
            status.values().forEach(EnabledHolder::makeImmutable);
            LOGGER.info("Disabled {} Capabilities on {} for: {}", new Object[]{type.serializedName, client ? "Client" : "Server", status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isDisabled()).map(Map.Entry::getKey).toList()});
        });
    }

    public static Map<Types, Map<Item, Boolean>> getEnabledMap() {
        EnumMap<Types, Map<Item, Boolean>> map = new EnumMap<Types, Map<Item, Boolean>>(Types.class);
        ENABLED_MAP.forEach((type, enMap) -> {
            HashMap enabledMap = new HashMap(enMap.size());
            enMap.forEach((item, enabledHolder) -> enabledMap.put(item, enabledHolder.isEnabled()));
            map.put((Types)((Object)type), enabledMap);
        });
        return map;
    }

    private static void registerCapabilities() {
        for (Types type : Types.values()) {
            ENABLED_MAP.put(type, new HashMap());
        }
        Map<Item, EnabledHolder> equipMap = ENABLED_MAP.get((Object)Types.EQUIP);
        CustomEquipCapability.CUSTOM_EQUIP_MAP.keySet().forEach(itemSupplier -> equipMap.put(itemSupplier.asItem(), new EnabledHolder()));
        Map<Item, EnabledHolder> throwMap = ENABLED_MAP.get((Object)Types.THROW);
        ThrowableItemCapability.THROWABLE_ITEM_MAP.keySet().forEach(itemSupplier -> throwMap.put(itemSupplier.asItem(), new EnabledHolder()));
    }

    private static void updateCapabilityStatus(Map<Types, Map<Item, Boolean>> enabledMap) {
        enabledMap.forEach((type, newMap) -> {
            Map<Item, EnabledHolder> map = ENABLED_MAP.get(type);
            newMap.forEach((item, enabledBool) -> {
                if (map.containsKey(item)) {
                    ((EnabledHolder)map.get(item)).and((boolean)enabledBool);
                } else {
                    LOGGER.error("Tried to {} Capability for an {}, but {} has no Capability", new Object[]{enabledBool != false ? "enable" : "disable", item, item});
                }
            });
        });
    }

    public static enum Types implements StringRepresentable
    {
        EQUIP("equip"),
        THROW("throwable");

        private static final Codec<Types> CODEC;
        private final String serializedName;

        private Types(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Types::values);
        }
    }

    private static class EnabledHolder {
        private boolean enabled = true;
        private boolean immutable = false;

        private EnabledHolder() {
        }

        public void and(boolean enabled) {
            if (this.immutable) {
                throw new UnsupportedOperationException("Cannot change the value of an Immutable EnabledHolder");
            }
            this.enabled = this.enabled && enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return !this.enabled;
        }

        public static EnabledHolder createImmutable(boolean enabled) {
            EnabledHolder enabledHolder = new EnabledHolder();
            enabledHolder.enabled = enabled;
            enabledHolder.makeImmutable();
            return enabledHolder;
        }

        public void makeImmutable() {
            this.immutable = true;
        }
    }
}

