/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform.services;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseItemMap;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IDataMapGetter {
    @Nullable
    public SoldierHoldableEffect getEffect(ItemStack var1);

    @Nullable
    public SoldierHoldableEffect getEffect(Item var1);

    @Nullable
    public SoldierMultiWearable getArmor(ItemStack var1);

    @Nullable
    public SoldierPoi getItemPoi(ItemStack var1);

    @Nullable
    public SoldierPoi getItemPoi(Item var1);

    @Nullable
    public SoldierPoi getBlockPoi(Block var1);

    @Nullable
    default public SoldierPoi getBlockPoi(ItemStack stack) {
        return this.getBlockPoi(stack.getItem());
    }

    @Nullable
    default public SoldierPoi getBlockPoi(Item item) {
        SoldierPoi soldierPoi;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            soldierPoi = this.getBlockPoi(blockItem.getBlock());
        } else {
            soldierPoi = null;
        }
        return soldierPoi;
    }

    default public ClayHorseWearableProperties getHorseArmor(Item item) {
        return ClayHorseItemMap.get(item);
    }

    @Nullable
    public SoldierVehicleProperties getVehicleProperties(EntityType<?> var1);

    @NotNull
    public List<Item> getHoldableEffectForSlot(SoldierEquipmentSlot var1);

    public static <T> void warnHoldable(Map<T, SoldierHoldableEffect> dataMap, BiPredicate<T, TagKey<Item>> isTagged) {
        dataMap.forEach((k, effect) -> {
            effect.getRemovalConditions().forEach(r -> {
                if (r.getChance() <= 0.0f) {
                    ClaySoldiersCommon.LOGGER.warn("DataMap: {} has a RemovalCondition({}) with chance 0", k, (Object)r.getDisplayName().getString());
                }
            });
            if (!isTagged.test(k, ModTags.Items.SOLDIER_HOLDABLE)) {
                ClaySoldiersCommon.LOGGER.warn("DataMap: {} is not tagged with {}", k, ModTags.Items.SOLDIER_HOLDABLE);
            }
        });
    }

    public static <T> Map<SoldierEquipmentSlot, List<Item>> createBySlotMap(Map<T, SoldierHoldableEffect> dataMap, Function<T, Item> keyToItem) {
        EnumMap<SoldierEquipmentSlot, List<Item>> map = new EnumMap<SoldierEquipmentSlot, List<Item>>(SoldierEquipmentSlot.class);
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            map.put(slot, new ArrayList());
        }
        dataMap.forEach((k, effect) -> effect.slots().forEach(slot -> ((List)map.get(slot)).add((Item)keyToItem.apply(k))));
        return map;
    }
}

