/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.recipe;

import java.util.ArrayList;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRecipes;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ClaySoldierCraftingRecipe
extends CustomRecipe {
    public ClaySoldierCraftingRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput input, Level level) {
        ArrayList<ItemStack> soldier = new ArrayList<ItemStack>();
        ItemStack dye = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemAtI = input.getItem(i);
            if (itemAtI.isEmpty()) continue;
            if (itemAtI.is((Item)ModItems.CLAY_SOLDIER.get())) {
                soldier.add(itemAtI);
                continue;
            }
            if (ClayMobTeamManger.getFromItem(itemAtI.getItem()) == null) continue;
            if (!dye.isEmpty()) {
                return false;
            }
            dye = itemAtI;
        }
        return !soldier.isEmpty() && !dye.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack soldierPuppet = ModItems.CLAY_SOLDIER.get().getDefaultInstance();
        int count = 0;
        ResourceLocation id = null;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemAtI = input.getItem(i);
            if (itemAtI.is((Item)ModItems.CLAY_SOLDIER.get())) {
                ++count;
                continue;
            }
            if (itemAtI.isEmpty()) continue;
            id = ClayMobTeamManger.getFromItem(itemAtI.getItem());
        }
        if (count > 0 && id != null) {
            ClaySoldierSpawnItem.setClayMobTeam(soldierPuppet, id, provider);
            soldierPuppet.setCount(count);
            return soldierPuppet;
        }
        throw new IllegalStateException("Crafting: Tried Crafting a Clay Soldier without a team item");
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<ClaySoldierCraftingRecipe> getSerializer() {
        return ModRecipes.CLAY_SOLDIER_CRAFTING.get();
    }
}

