/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.recipe;

import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShearBladeRecipe
extends CustomRecipe {
    public ShearBladeRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack shear = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemAtI = input.getItem(i);
            if (itemAtI.isEmpty() || !itemAtI.is(Items.SHEARS)) continue;
            if (!shear.isEmpty() || shear.getDamageValue() > 0) {
                return false;
            }
            shear = itemAtI;
        }
        return !shear.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        return ModItems.SHEAR_BLADE.get().getDefaultInstance();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        NonNullList nonnulllist = NonNullList.withSize((int)craftingInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = craftingInput.getItem(i);
            if (!item.is(Items.SHEARS)) continue;
            nonnulllist.set(i, (Object)ModItems.SHEAR_BLADE.get().getDefaultInstance());
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 1;
    }

    @NotNull
    public RecipeSerializer<ShearBladeRecipe> getSerializer() {
        return ModRecipes.SHEAR_BLADE_CRAFTING.get();
    }

    public boolean isSpecial() {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ModItems.SHEAR_BLADE.get().getDefaultInstance();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.SHEARS})});
    }
}

