/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunction;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claypoifunction.ClaySoldierInventorySetter;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicate;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SoldierPoi {
    public static final Codec<SoldierPoi> CODEC = RecordCodecBuilder.create(in -> in.group((App)ClayPoiFunction.CODEC.listOf().fieldOf("effect").forGetter(p -> p.effects), (App)ClayPredicate.CODEC.fieldOf("predicate").forGetter(p -> p.canUse), (App)CodecUtils.CHANCE_CODEC.optionalFieldOf("break_chance", (Object)Float.valueOf(0.0f)).forGetter(p -> Float.valueOf(p.breakChance))).apply((Applicative)in, SoldierPoi::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoldierPoi> STREAM_CODEC = StreamCodec.composite(ClayPoiFunction.LIST_STREAM_CODEC, p -> p.effects, ClayPredicate.STREAM_CODEC, SoldierPoi::getPredicate, (StreamCodec)ByteBufCodecs.FLOAT, SoldierPoi::getBreakChance, SoldierPoi::new);
    private final List<ClayPoiFunction<?>> effects;
    private final ClayPredicate<?> canUse;
    private final float breakChance;

    public SoldierPoi(List<ClayPoiFunction<?>> effects, ClayPredicate<?> canUse, float breakChance) {
        this.effects = effects;
        this.canUse = canUse;
        this.breakChance = breakChance;
    }

    public SoldierPoi(ClayPoiFunction<?> effect, ClayPredicate<?> canUse, float breakChance) {
        this(List.of(effect), canUse, breakChance);
    }

    public float getBreakChance() {
        return this.breakChance;
    }

    public boolean canPerformEffect(ClaySoldierInventoryQuery soldier) {
        return this.canUse.test(soldier);
    }

    public void performEffect(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
        this.effects.forEach(ef -> ef.accept(soldier, source));
    }

    public List<ClayPoiFunction<?>> getEffects() {
        return this.effects;
    }

    public ClayPredicate<?> getPredicate() {
        return this.canUse;
    }

    public String toString() {
        return "P[" + this.breakChance + "]";
    }
}

