/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.ClayMobItemBreakParticles;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithSource;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class SoldierPoiWithItem
extends SoldierPoiWithSource<ItemEntity> {
    public SoldierPoiWithItem(ItemEntity source) {
        super(ClaySoldiersCommon.DATA_MAP.getItemPoi(source.getItem()), source);
    }

    @Override
    protected ClayPoiSource createPoiSource(ItemEntity source) {
        return ClayPoiSource.createSource(source);
    }

    @Override
    public void animateEffect(ClayMobEntity entity) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)entity, new ClayMobItemBreakParticles(entity.getId(), ((ItemEntity)this.getSource()).getItem().getItem()));
    }

    @Override
    public void startPath(PathNavigation navigation) {
        Path path = navigation.createPath((Entity)this.getSource(), 0);
        navigation.moveTo(path, 1.3);
    }

    @Override
    public void onUse(ItemEntity source, AbstractClaySoldierEntity soldier) {
        assert (this.getPoi() != null);
        source.setExtendedLifetime();
        float breakChance = this.getPoi().getBreakChance();
        if (breakChance <= 0.0f) {
            return;
        }
        if (source.getItem().isEmpty()) {
            source.discard();
            return;
        }
        if (source.level().isClientSide()) {
            return;
        }
        if (source.getRandom().nextFloat() <= breakChance) {
            source.getItem().shrink(1);
            this.take(source, soldier);
            if (source.getItem().isEmpty()) {
                source.discard();
            }
        }
    }

    private void take(ItemEntity pEntity, AbstractClaySoldierEntity soldier) {
        Level level;
        if (!pEntity.isRemoved() && (level = pEntity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getChunkSource().broadcast((Entity)pEntity, (Packet)new ClientboundTakeItemEntityPacket(pEntity.getId(), soldier.getId(), 1));
        }
    }

    @Override
    public String toString() {
        return "Poi{" + String.valueOf(this.getPoi()) + ", " + String.valueOf(((ItemEntity)this.getSource()).getItem()) + "}";
    }
}

