/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public class DamageBlock {
    public static final DamageBlock EMPTY = new DamageBlock(0.0f, 0.0f, false){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    public static final ValueCombiner<DamageBlock> COMBINER = CombinedDamageBlock::new;
    public static final ToIntFunction<DamageBlock> TO_INT = d -> d.blockAmount > 0.0f && d.blockChance > 0.0f ? 1 : 0;
    public static final Codec<DamageBlock> CODEC = RecordCodecBuilder.create(in -> in.group((App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("chance").forGetter(d -> Float.valueOf(d.blockChance)), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("amount").forGetter(d -> Float.valueOf(d.blockAmount)), (App)Codec.BOOL.optionalFieldOf("pierceable", (Object)true).forGetter(d -> d.pierceable)).apply((Applicative)in, DamageBlock::new));
    public static final StreamCodec<ByteBuf, DamageBlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, d -> Float.valueOf(d.blockChance), (StreamCodec)ByteBufCodecs.FLOAT, d -> Float.valueOf(d.blockAmount), (StreamCodec)ByteBufCodecs.BOOL, d -> d.pierceable, DamageBlock::new);
    public static final BiFunction<String, DamageBlock, List<Component>> DISPLAY_NAME_CREATOR = (key, value) -> {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)key).append(":"));
        value.appendNameToList(list);
        return list;
    };
    private final float blockChance;
    private final float blockAmount;
    private final boolean pierceable;

    public DamageBlock(float blockChance, float blockAmount, boolean pierceable) {
        this.blockChance = blockChance;
        this.blockAmount = blockAmount;
        this.pierceable = pierceable;
    }

    public DamageBlock(float blockChance, float blockAmount) {
        this(blockChance, blockAmount, true);
    }

    public float blocked(RandomSource random, float damage, boolean isPiercing) {
        if (this.blockChance <= 0.0f || this.blockAmount <= 0.0f) {
            return damage;
        }
        if ((!isPiercing || this.pierceable) && random.nextFloat() > this.blockChance) {
            float newDamage = damage - this.blockAmount;
            return newDamage < 0.0f ? 0.0f : newDamage;
        }
        return damage;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return "DamageBlock(Empty)";
        }
        return "DamageBlock(Chance: %f, Amount: %f)".formatted(Float.valueOf(this.blockChance), Float.valueOf(this.blockAmount));
    }

    public String asString() {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return "";
        }
        return " (Chance: %.2f Amount: %.2f)".formatted(Float.valueOf(this.blockChance), Float.valueOf(this.blockAmount));
    }

    protected void appendNameToList(List<Component> tooltip) {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return;
        }
        tooltip.add((Component)CommonComponents.space().append(this.asString()).withStyle(ChatFormatting.DARK_GRAY));
    }

    private static class CombinedDamageBlock
    extends DamageBlock {
        private final DamageBlock damageBlock1;
        private final DamageBlock damageBlock2;

        public CombinedDamageBlock(DamageBlock damageBlock1, DamageBlock damageBlock2) {
            super(0.0f, 0.0f, false);
            this.damageBlock1 = damageBlock1;
            this.damageBlock2 = damageBlock2;
        }

        @Override
        public float blocked(RandomSource random, float damage, boolean isPiercing) {
            float newDamage = this.damageBlock1.blocked(random, damage, isPiercing);
            return this.damageBlock2.blocked(random, newDamage, isPiercing);
        }

        @Override
        public String toString() {
            if (this.damageBlock1.isEmpty()) {
                return this.damageBlock2.toString();
            }
            return String.valueOf(this.damageBlock1) + (String)(this.damageBlock2.isEmpty() ? "" : ", " + String.valueOf(this.damageBlock2));
        }

        @Override
        protected void appendNameToList(List<Component> tooltip) {
            this.damageBlock1.appendNameToList(tooltip);
            this.damageBlock2.appendNameToList(tooltip);
        }
    }
}

