/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public record WraithProperty(int duration, float damage, List<SpecialAttack<?>> attackModifiers) implements ITranslatableProperty
{
    public static final WraithProperty EMPTY = new WraithProperty(-1, 0.0f, List.of());
    public static final ToIntFunction<WraithProperty> TO_INT = WraithProperty::duration;
    public static final ValueCombiner<WraithProperty> COMBINER = WraithProperty::combine;
    public static final Codec<WraithProperty> CODEC = RecordCodecBuilder.create(in -> in.group((App)CodecUtils.TIME_CODEC.fieldOf("duration").forGetter(WraithProperty::duration), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(WraithProperty::damage), (App)SpecialAttack.LIST_CODEC.optionalFieldOf("attack_effect", List.of()).forGetter(WraithProperty::attackModifiers)).apply((Applicative)in, WraithProperty::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WraithProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, WraithProperty::duration, (StreamCodec)ByteBufCodecs.FLOAT, WraithProperty::damage, (StreamCodec)SpecialAttack.STREAM_CODEC.apply(ByteBufCodecs.list()), WraithProperty::attackModifiers, WraithProperty::new);

    private WraithProperty combine(WraithProperty other) {
        return new WraithProperty(Math.max(this.duration, other.duration), Math.max(this.damage, other.damage), SpecialAttack.COMBINER.combine(this.attackModifiers, other.attackModifiers));
    }

    @Override
    public Component getDisplayName() {
        return Component.literal((String)("Wraith: " + this.duration + "s")).withColor(261343);
    }

    public Consumer<ClayWraithEntity> onSpawnEffect() {
        return wraith -> {
            wraith.getAttributes().addTransientAttributeModifiers((Multimap)Multimaps.forMap(Map.of(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"bonus_damage"), (double)this.damage, AttributeModifier.Operation.ADD_VALUE))));
            wraith.setAttackFunctions(this.attackModifiers);
        };
    }
}

