/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityType;
import net.bumblebee.claysoldiers.soldierproperties.translation.EffectTranslatableProperty;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;

public class EffectImmunityMap
implements Iterable<ITranslatableProperty> {
    public static final Codec<EffectImmunityMap> CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.MOB_EFFECT.holderByNameCodec(), EffectImmunityType.CODEC).xmap(EffectImmunityMap::fromMap, EffectImmunityMap::fromImmunityMap);
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<Holder<MobEffect>, EffectImmunityType>> MAP_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)MobEffect.STREAM_CODEC, EffectImmunityType.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, EffectImmunityMap> STREAM_CODEC = MAP_STREAM_CODEC.map(EffectImmunityMap::new, EffectImmunityMap::fromImmunityMap);
    public static final EffectImmunityMap EMPTY = new EffectImmunityMap();
    public static final ToIntFunction<EffectImmunityMap> TO_INT = EffectImmunityMap::size;
    public static final ValueCombiner<EffectImmunityMap> COMBINER = EffectImmunityMap::combine;
    private final Map<Holder<MobEffect>, EffectImmunityType> immuneEffects;

    public EffectImmunityMap() {
        this.immuneEffects = new HashMap<Holder<MobEffect>, EffectImmunityType>();
    }

    public EffectImmunityMap(Map<Holder<MobEffect>, EffectImmunityType> effectMap) {
        this.immuneEffects = new HashMap<Holder<MobEffect>, EffectImmunityType>(effectMap);
    }

    private static EffectImmunityMap combine(EffectImmunityMap map1, EffectImmunityMap map2) {
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        EffectImmunityMap combined = new EffectImmunityMap(map1.immuneEffects);
        combined.putAll(map2.immuneEffects);
        return combined;
    }

    private static EffectImmunityMap fromMap(Map<Holder<MobEffect>, EffectImmunityType> immuneEffects) {
        return new EffectImmunityMap(immuneEffects);
    }

    private static Map<Holder<MobEffect>, EffectImmunityType> fromImmunityMap(EffectImmunityMap map) {
        return map.immuneEffects;
    }

    public void put(Holder<MobEffect> effect, EffectImmunityType newType) {
        this.immuneEffects.compute(effect, (key, value) -> {
            if (value == null) {
                return newType;
            }
            return value == newType ? value : null;
        });
    }

    private void putAll(Map<Holder<MobEffect>, EffectImmunityType> effects) {
        effects.forEach(this::put);
    }

    public boolean isImmune(Holder<MobEffect> mobEffect) {
        return this.immuneEffects.get(mobEffect) == EffectImmunityType.IMMUNE;
    }

    public boolean isPersistent(Holder<MobEffect> mobEffect) {
        return this.immuneEffects.get(mobEffect) == EffectImmunityType.PERSISTENT;
    }

    protected int size() {
        return this.immuneEffects.size();
    }

    protected boolean isEmpty() {
        return this.immuneEffects.isEmpty();
    }

    @Override
    public Iterator<ITranslatableProperty> iterator() {
        return this.immuneEffects.entrySet().stream().map(EffectImmunityMap::create).iterator();
    }

    public String toString() {
        return "EffectImmunityMap" + String.valueOf(this.immuneEffects);
    }

    private static ITranslatableProperty create(Map.Entry<Holder<MobEffect>, EffectImmunityType> mapEntry) {
        return ITranslatableProperty.keyValuePair(EffectTranslatableProperty.create(mapEntry.getKey()), mapEntry.getValue());
    }
}

