/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.translation;

import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public interface EffectTranslatableProperty
extends ITranslatableProperty {
    public Component getEffectDisplayName();

    public int getEffectColor();

    @Override
    @Nullable
    default public Component getDisplayName() {
        return this.getEffectDisplayName().copy().withColor(this.getEffectColor());
    }

    public static EffectTranslatableProperty create(final MobEffect effect) {
        return new EffectTranslatableProperty(){

            @Override
            public Component getEffectDisplayName() {
                return effect.getDisplayName();
            }

            @Override
            public int getEffectColor() {
                return effect.getColor();
            }
        };
    }

    public static EffectTranslatableProperty create(Holder<MobEffect> effect) {
        return EffectTranslatableProperty.create((MobEffect)effect.value());
    }
}

