/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.types;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public class BreathHoldPropertyType
extends SoldierPropertyType<Integer> {
    private static final Codec<Integer> CODEC = CodecUtils.withReplacementValues((Codec)Codec.INT, BreathHoldProperty.CODEC_SPECIAL, (Supplier[])BreathHoldProperty.values());
    public static final int MAX_BREATH_HOLD = 1000;
    public static final int NO_BREATH_HOLD = -200;

    public BreathHoldPropertyType() {
        super(CODEC, ByteBufCodecs.VAR_INT.cast(), BreathHoldProperty.NORMAL.get(), SoldierPropertyTypes.INT_AS_INT, SoldierPropertyTypes.INT_COMBINER, null);
    }

    @Override
    public List<Component> getDisplayNameWithValue(Integer value, @Nullable ClaySoldierInventoryQuery soldier) {
        MutableComponent name = Component.translatable((String)this.getDescriptionId()).append(": ");
        if (value >= 1000) {
            name.append((Component)Component.translatable((String)BreathHoldProperty.INFINITE.translatableKey()));
        } else if (value <= -200) {
            name.append((Component)Component.translatable((String)BreathHoldProperty.NONE.translatableKey()));
        } else {
            name.append(value.toString());
        }
        return List.of(name);
    }

    public static enum BreathHoldProperty implements StringRepresentable,
    Supplier<Integer>,
    KeyableTranslatableProperty
    {
        NONE("none", -200),
        NORMAL("normal", 0),
        INFINITE("infinite", 1000);

        public static final Codec<BreathHoldProperty> CODEC_SPECIAL;
        private final String serializedName;
        private final int amount;

        private BreathHoldProperty(String name, int amount) {
            this.serializedName = name;
            this.amount = amount;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public Integer get() {
            return this.amount;
        }

        public String toString() {
            return this.serializedName;
        }

        @Override
        public String translatableKey() {
            return SoldierPropertyTypes.BREATH_HOLD.get().getDescriptionId() + "." + this.serializedName;
        }

        static {
            CODEC_SPECIAL = StringRepresentable.fromEnum(BreathHoldProperty::values);
        }
    }
}

