/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ClayMobTeam {
    public static final Codec<ClayMobTeam> CODEC_JSON = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("name").forGetter(ClayMobTeam::getName), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(c -> c.color), (App)Codec.BOOL.optionalFieldOf("friendly_fire", (Object)false).forGetter(ClayMobTeam::isFriendlyFireAllowed), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("from", (Object)Items.AIR).forGetter(ClayMobTeam::getGetFromOrAir), (App)SoldierPropertyMap.CODEC_FOR_NON_ITEM.optionalFieldOf("properties", (Object)SoldierPropertyMap.EMPTY_MAP).forGetter(ClayMobTeam::getProperties), (App)PlayerUUIDAndName.CODEC.listOf().optionalFieldOf("players", List.of()).forGetter(c -> c.players)).apply((Applicative)in, ClayMobTeam::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClayMobTeam> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ClayMobTeam::getName, ColorHelper.STREAM_CODEC, c -> c.color, (StreamCodec)ByteBufCodecs.BOOL, ClayMobTeam::isFriendlyFireAllowed, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), t -> t.getFrom == null ? Items.AIR : t.getFrom, SoldierPropertyMap.STREAM_CODEC, ClayMobTeam::getProperties, (StreamCodec)PlayerUUIDAndName.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), c -> c.players, ClayMobTeam::new);
    public static final String TEAM_ID_TAG = "team_id";
    private static final String FORMATTED_TEAM_ID_TAG = "%s_team_id";
    private final String name;
    private final ColorHelper color;
    private final boolean friendlyFire;
    @Nullable
    private final Item getFrom;
    private final SoldierPropertyMap properties;
    private final List<PlayerUUIDAndName> players;
    private final Collection<UUID> playerUUIDs;
    private final List<String> playerNames;

    private ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull Item getFrom, SoldierPropertyMap properties, Collection<PlayerUUIDAndName> players) {
        this.name = name;
        this.color = color;
        this.friendlyFire = friendlyFire;
        this.getFrom = getFrom == Items.AIR ? null : getFrom;
        this.properties = properties;
        this.players = List.copyOf(players);
        this.playerUUIDs = players.stream().map(PlayerUUIDAndName::uuid).toList();
        this.playerNames = players.stream().map(PlayerUUIDAndName::name).toList();
    }

    protected ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull Item getFrom) {
        this(name, color, friendlyFire, getFrom, SoldierPropertyMap.EMPTY_MAP, List.of());
    }

    private ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull Item getFrom, SoldierPropertyMap properties) {
        this(name, color, friendlyFire, getFrom, properties, List.of());
    }

    public SoldierPropertyMap getProperties() {
        return this.properties;
    }

    public Component getDisplayNameWithColor(ToIntFunction<ColorHelper> colorFunction) {
        return Component.literal((String)this.getName()).withColor(colorFunction.applyAsInt(this.color));
    }

    public Component getDisplayName() {
        return Component.literal((String)this.getName());
    }

    private String getName() {
        return this.name;
    }

    public int getColor(LivingEntity livingEntity, float partialTick) {
        return this.color.getColor(livingEntity, partialTick);
    }

    public int getColor(int offsetStart, int tick, float partialTick) {
        return this.color.getColor(offsetStart, tick, partialTick);
    }

    @Nullable
    public Item getGetFrom() {
        return this.getFrom;
    }

    private Item getGetFromOrAir() {
        return this.getFrom != null ? this.getFrom : Items.AIR;
    }

    public boolean isFriendlyFireAllowed() {
        return this.friendlyFire;
    }

    public boolean isCooperative() {
        return true;
    }

    public @UnmodifiableView Collection<UUID> getPlayers() {
        return this.playerUUIDs;
    }

    public @UnmodifiableView List<String> getPlayerNames() {
        return this.playerNames;
    }

    public boolean canBeUsed(Player player) {
        return this.players.isEmpty() || this.players.contains(new PlayerUUIDAndName(player.getGameProfile()));
    }

    public boolean hasPlayer() {
        return !this.players.isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClayMobTeam otherTeam = (ClayMobTeam)other;
        return this.color.equals(otherTeam.color) && this.friendlyFire == otherTeam.friendlyFire && this.name.equalsIgnoreCase(otherTeam.name) && Objects.equals(this.players, otherTeam.players);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.color, this.friendlyFire);
    }

    public String toString() {
        return "ClayMobTeam{" + this.name + "', " + String.valueOf(this.color) + (this.friendlyFire ? " friendlyFire" : "") + String.valueOf(this.playerNames.isEmpty() ? "" : this.playerNames) + "}";
    }

    public static void save(ResourceLocation key, CompoundTag tag) {
        tag.putString(TEAM_ID_TAG, key.toString());
    }

    public static ResourceLocation read(CompoundTag tag) {
        return ResourceLocation.parse((String)tag.getString(TEAM_ID_TAG));
    }

    public static void save(ResourceLocation key, CompoundTag tag, String prefix) {
        tag.putString(FORMATTED_TEAM_ID_TAG.formatted(prefix), key.toString());
    }

    public static ResourceLocation read(CompoundTag tag, String prefix) {
        return ResourceLocation.parse((String)tag.getString(FORMATTED_TEAM_ID_TAG.formatted(prefix)));
    }

    public static Builder of(String name, ColorHelper color) {
        return new Builder(name, color);
    }

    private record PlayerUUIDAndName(UUID uuid, String name) {
        public static final Codec<PlayerUUIDAndName> CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(PlayerUUIDAndName::uuid), (App)Codec.STRING.fieldOf("name").forGetter(PlayerUUIDAndName::name)).apply((Applicative)in, PlayerUUIDAndName::new));
        public static final StreamCodec<ByteBuf, PlayerUUIDAndName> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PlayerUUIDAndName::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerUUIDAndName::name, PlayerUUIDAndName::new);

        private PlayerUUIDAndName(GameProfile profile) {
            this(profile.getId(), profile.getName());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerUUIDAndName that = (PlayerUUIDAndName)o;
            return Objects.equals(this.uuid, that.uuid);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.uuid);
        }
    }

    public static class Builder {
        private SoldierPropertyMap properties = SoldierPropertyMap.EMPTY_MAP;
        private Item getFrom = Items.AIR;
        private boolean friendlyFire = false;
        private final String name;
        private final ColorHelper color;

        public Builder(String name, ColorHelper color) {
            this.name = name;
            this.color = color;
        }

        public Builder setProperties(SoldierPropertyMap properties) {
            this.properties = properties;
            return this;
        }

        public Builder setGetFrom(@NotNull Item getFrom) {
            this.getFrom = getFrom;
            return this;
        }

        public Builder allowFriendlyFire() {
            this.friendlyFire = true;
            return this;
        }

        public ClayMobTeam build() {
            return new ClayMobTeam(this.name, this.color, this.friendlyFire, this.getFrom, this.properties);
        }
    }
}

