/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import java.util.UUID;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TeamHolder
extends OwnableEntity {
    @NotNull
    public ClayMobTeam getClayTeam();

    public ResourceLocation getClayTeamType();

    default public void setClayTeamType(ResourceLocation type) {
    }

    default public boolean hasNoTeam() {
        return !this.getClayTeam().isCooperative();
    }

    default public boolean shouldAttackTeamHolder(TeamHolder teamHolder) {
        if (this.hasNoTeam() || teamHolder.hasNoTeam()) {
            return true;
        }
        return !this.getClayTeam().equals(teamHolder.getClayTeam());
    }

    default public boolean sameTeamAs(Entity other) {
        if (!(other instanceof TeamHolder)) {
            return false;
        }
        TeamHolder teamHolder = (TeamHolder)other;
        if (this.hasNoTeam() || teamHolder.hasNoTeam()) {
            return false;
        }
        return this.getClayTeam().equals(teamHolder.getClayTeam());
    }

    @Nullable
    public Player getClayTeamOwner();

    default public boolean hasClayTeamOwner() {
        return this.getClayTeamOwnerUUID() != null;
    }

    @Nullable
    public UUID getClayTeamOwnerUUID();

    default public boolean isOwnedBy(Player player) {
        return player.getUUID().equals(this.getClayTeamOwnerUUID());
    }

    default public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        OwnableEntity ownableEntity;
        if (target instanceof ClayMobEntity) {
            ClayMobEntity clayMobEntity = (ClayMobEntity)target;
            return !owner.equals((Object)clayMobEntity.getClayTeamOwner());
        }
        return !(target instanceof OwnableEntity) || !owner.equals((Object)(ownableEntity = (OwnableEntity)target).getOwner());
    }

    public boolean tryClaimingTeam(Player var1);

    default public boolean unableToMoveToOwner() {
        return this.getClayTeamOwner() == null || this.getClayTeamOwner().isSpectator() || this.isOrderedToSit();
    }

    public boolean isOrderedToSit();

    public void setOrderedToSit(boolean var1);

    public boolean isInSittingPose();

    public void setInSittingPose(boolean var1);

    @Nullable
    default public UUID getOwnerUUID() {
        return this.getClayTeamOwnerUUID();
    }

    public EntityGetter level();

    @Nullable
    default public LivingEntity getOwner() {
        return this.getClayTeamOwner();
    }
}

