/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface TeamPlayerData {
    public static final Codec<PlayerData> PLAYER_DATA_CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(PlayerData::getUUID), (App)ComponentSerialization.CODEC.fieldOf("lastKnowName").forGetter(PlayerData::getLastDisplayName)).apply((Applicative)in, PlayerData::new));

    public boolean putPlayerIfAbsent(ResourceLocation var1, Player var2);

    @Nullable
    public PlayerData getPlayerForTeam(ResourceLocation var1);

    public long lastChangeTime();

    public void forEach(BiConsumer<ResourceLocation, PlayerData> var1);

    public void updatePlayerName(ResourceLocation var1, Player var2);

    public static class PlayerData {
        private final UUID player;
        private Component lastKnowName;

        public PlayerData(UUID player, Component lastKnowName) {
            this.player = player;
            this.lastKnowName = lastKnowName;
        }

        public static PlayerData of(Player player) {
            return new PlayerData(player.getUUID(), player.getDisplayName());
        }

        public UUID getUUID() {
            return this.player;
        }

        public void setLastKnowName(Component lastKnowName) {
            this.lastKnowName = lastKnowName;
        }

        public boolean is(Player player) {
            return this.getUUID().equals(player.getUUID());
        }

        public Component getLastDisplayName() {
            return this.lastKnowName;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerData data = (PlayerData)o;
            return this.player.equals(data.player);
        }

        public int hashCode() {
            return this.player.hashCode();
        }

        public String toString() {
            return "Player(%s)".formatted(this.lastKnowName.getString());
        }
    }
}

