/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class ComponentFormating {
    public static final String SOLDIER_PROPERTIES_EQUIP = "item.tooltip.csr.soldier_properties_equip";
    public static final String SOLDIER_PROPERTIES_EQUIP_AND_PREDICATE = "item.tooltip.csr.soldier_properties_equip_predicate";
    public static final String CLAY_HORSE_PROPERTIES_EQUIP = "item.tooltip.csr.clay_horse_properties_equip";
    public static final String SOLDIER_BECOMES_ATTACK_TYPE = "item.tooltip.csr.soldier_becomes_attack_type";
    public static final String SOLDIER_POI_ITEM = "item.tooltip.csr.soldier_poi_item";
    public static final String SOLDIER_POI_BLOCK = "item.tooltip.csr.soldier_poi_block";
    public static final String SOLDIER_POI_PREDICATE = "item.tooltip.csr.soldier_poi_predicate";
    public static final String SOLDIER_POI_EFFECT = "item.tooltip.csr.soldier_poi_effect";
    public static final String SOLDIER_ITEM_PICKUP_EFFECT = "item.tooltip.csr.soldier_pickup_effect";
    public static final String SOLDIER_ITEM_PICKUP_REMOVE = "item.tooltip.csr.soldier_removal_condition";
    public static final String CLAY_HORSE_PROTECTION = "item.tooltip.csr.clay_horse.protection";
    private static final String DOUBLE_SPACE = "  ";

    public static void addHoldableTooltip(@Nullable SoldierHoldableEffect holdableEffect, List<Component> tooltip) {
        if (holdableEffect == null) {
            return;
        }
        Component predicateDisplayName = holdableEffect.predicate().getDisplayName();
        if (predicateDisplayName != null) {
            tooltip.add((Component)CommonComponents.space().append((Component)Component.translatable((String)SOLDIER_PROPERTIES_EQUIP_AND_PREDICATE).withStyle(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)CommonComponents.space().append(CommonComponents.SPACE).append(predicateDisplayName).withStyle(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)SOLDIER_PROPERTIES_EQUIP).withStyle(ChatFormatting.DARK_GRAY));
        }
        Component attackTypeLang = holdableEffect.properties().attackType().getAnimatedDisplayName((LivingEntity)Minecraft.getInstance().player);
        if (attackTypeLang != null) {
            tooltip.add((Component)Component.translatable((String)SOLDIER_BECOMES_ATTACK_TYPE, (Object[])new Object[]{attackTypeLang}).withStyle(ChatFormatting.DARK_GRAY));
        }
        ComponentFormating.formatProperties(tooltip, holdableEffect.properties(), List.of(SoldierPropertyTypes.ATTACK_TYPE.get()), null);
        ComponentFormating.formatListDisplayNamesMultiLine(tooltip, holdableEffect.getOnPickUpFunctions(), (Component)Component.translatable((String)SOLDIER_ITEM_PICKUP_EFFECT), clayPoiFunction -> clayPoiFunction.getDisplayNameDynamic((Player)Minecraft.getInstance().player));
        ComponentFormating.formatListDisplayNames(tooltip, holdableEffect.getRemovalConditions(), (Component)Component.translatable((String)SOLDIER_ITEM_PICKUP_REMOVE), RemovalCondition::getDisplayName);
    }

    public static void addPoiTooltip(@Nullable SoldierPoi poi, List<Component> tooltip) {
        if (poi == null) {
            return;
        }
        Component predicateDisplayName = poi.getPredicate().getDisplayName();
        if (predicateDisplayName != null) {
            tooltip.add((Component)CommonComponents.space().append((Component)Component.translatable((String)SOLDIER_POI_PREDICATE).withStyle(ChatFormatting.DARK_GRAY)));
            tooltip.add((Component)Component.literal((String)DOUBLE_SPACE).append(predicateDisplayName).withStyle(ChatFormatting.DARK_GRAY));
        }
        ComponentFormating.formatListDisplayNamesMultiLine(tooltip, poi.getEffects(), (Component)Component.translatable((String)SOLDIER_POI_EFFECT), clayPoiFunction -> clayPoiFunction.getDisplayNameDynamic((Player)Minecraft.getInstance().player));
    }

    public static void formatProperties(List<Component> tooltip, Iterable<SoldierProperty<?>> properties, List<SoldierPropertyType<?>> hiddenProperties, @Nullable ClaySoldierInventoryQuery soldier) {
        for (SoldierProperty<?> soldierProperty : properties) {
            if (hiddenProperties.contains(soldierProperty.type())) continue;
            ComponentFormating.formatProperty(tooltip, soldierProperty, soldier);
        }
    }

    private static void formatProperty(List<Component> tooltip, SoldierProperty<?> property, @Nullable ClaySoldierInventoryQuery soldier) {
        Object propertyValue = property.value();
        MutableComponent propertyComponent = CommonComponents.space().withStyle(ChatFormatting.DARK_GRAY);
        if (property.type().is(ModTags.SoldierPropertyTypes.REQUIRES_OWNER) && soldier != null && soldier.getClayTeamOwner() != null) {
            return;
        }
        tooltip.add((Component)propertyComponent);
        if (propertyValue instanceof Iterable) {
            Iterable listValue = (Iterable)propertyValue;
            propertyComponent.append(property.type().getDisplayName());
            propertyComponent.append((Component)Component.literal((String)":"));
            ComponentFormating.formatList(tooltip, listValue);
        } else if (propertyValue instanceof ITranslatableProperty) {
            ITranslatableProperty soldierProperty = (ITranslatableProperty)propertyValue;
            Component displayName = soldierProperty.getAnimatedDisplayName((LivingEntity)Minecraft.getInstance().player);
            if (displayName != null) {
                propertyComponent.append(displayName);
            }
        } else {
            List<Component> compList = ComponentFormating.formatProperty(property, soldier);
            if (compList.isEmpty()) {
                tooltip.removeLast();
                return;
            }
            propertyComponent.append(compList.getFirst());
            for (int i = 1; i < compList.size(); ++i) {
                tooltip.add(compList.get(i));
            }
        }
    }

    private static void formatList(List<Component> tooltip, Iterable<?> values) {
        for (Object value : values) {
            MutableComponent propertyComponent = CommonComponents.space();
            tooltip.add((Component)propertyComponent);
            propertyComponent.append(CommonComponents.SPACE);
            propertyComponent.append(CommonComponents.SPACE).withStyle(ChatFormatting.DARK_GRAY);
            if (value instanceof ITranslatableProperty) {
                ITranslatableProperty soldierProperty = (ITranslatableProperty)value;
                Component displayName = soldierProperty.getAnimatedDisplayName((LivingEntity)Minecraft.getInstance().player);
                if (displayName == null) continue;
                propertyComponent.append(displayName);
                continue;
            }
            propertyComponent.append((Component)Component.literal((String)value.toString()));
        }
    }

    private static <T> List<Component> formatProperty(SoldierProperty<T> property, @Nullable ClaySoldierInventoryQuery soldier) {
        return property.type().getDisplayNameWithValue(property.value(), soldier);
    }

    public static void formatClayHorseProperties(@Nullable ClayHorseWearableProperties effect, List<Component> tooltip) {
        if (effect == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)CLAY_HORSE_PROPERTIES_EQUIP).withStyle(ChatFormatting.DARK_GRAY));
        if (effect.protection() != 0.0f) {
            tooltip.add((Component)CommonComponents.space().append((Component)Component.translatable((String)CLAY_HORSE_PROTECTION, (Object[])new Object[]{Float.valueOf(effect.protection())})).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static <T> void formatListDisplayNames(List<Component> tooltip, Collection<T> effects, Component heading, Function<T, Component> displayNameGetter) {
        if (!effects.isEmpty()) {
            tooltip.add((Component)CommonComponents.space().append(heading).withStyle(ChatFormatting.DARK_GRAY));
        }
        for (T effect : effects) {
            Component displayName = displayNameGetter.apply(effect);
            if (displayName == null) continue;
            tooltip.add((Component)Component.literal((String)DOUBLE_SPACE).append(displayName).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static <T> void formatListDisplayNamesMultiLine(List<Component> tooltip, Collection<T> effects, Component heading, Function<T, List<Component>> displayNameGetter) {
        if (!effects.isEmpty()) {
            tooltip.add((Component)CommonComponents.space().append(heading).withStyle(ChatFormatting.DARK_GRAY));
        }
        for (T effect : effects) {
            displayNameGetter.apply(effect).forEach(component -> tooltip.add((Component)Component.literal((String)DOUBLE_SPACE).append(component).withStyle(ChatFormatting.DARK_GRAY)));
        }
    }
}

