/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import org.slf4j.Logger;

public interface ErrorHandler {
    public static final ErrorHandler INSTANCE = ClaySoldiersCommon.PLATFORM.isDevEnv() ? ErrorHandler.createThrowing() : ErrorHandler.createLogging(ClaySoldiersCommon.LOGGER);

    default public void error(String message) {
        this.handle(new IllegalStateException(message));
    }

    default public void debug(String message) {
        this.error(message);
    }

    default public void hide(String message) {
    }

    public void handle(RuntimeException var1);

    public void handle(String var1, RuntimeException var2);

    private static ErrorHandler createLogging(final Logger logger) {
        return new ErrorHandler(){

            @Override
            public void handle(String msg, RuntimeException e) {
                logger.error(msg, (Throwable)e);
            }

            @Override
            public void handle(RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }

            @Override
            public void error(String message) {
                logger.error(message);
            }

            @Override
            public void debug(String message) {
                logger.debug(message);
            }
        };
    }

    private static ErrorHandler createThrowing() {
        return new ErrorHandler(){

            @Override
            public void handle(String msg, RuntimeException e) {
                throw e;
            }

            @Override
            public void handle(RuntimeException e) {
                throw e;
            }

            @Override
            public void hide(String message) {
                this.error(message);
            }
        };
    }
}

