/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.Nullable;

public final class CodecUtils {
    public static final Codec<Float> CHANCE_CODEC = Codec.either((Codec)Codec.floatRange((float)0.0f, (float)1.0f), (Codec)Codec.STRING).comapFlatMap(CodecUtils::getFromChanceEither, CodecUtils::createChanceEither);
    public static final Codec<Integer> TIME_CODEC = Codec.either((Codec)ExtraCodecs.NON_NEGATIVE_INT, (Codec)Codec.STRING).comapFlatMap(CodecUtils::getTimeFromEither, time -> time % 20 == 0 ? Either.right((Object)(time / 20 + "s")) : Either.left((Object)time));
    private static final Codec<ResourceLocation> CODEC_DEFAULT_MOD_ID = Codec.STRING.comapFlatMap(CodecUtils::read, CodecUtils::fromStringResourceLocation).stable();

    private static DataResult<Float> getFromChanceEither(Either<Float, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)((Float)either.left().get()));
        }
        String parsedString = (String)either.right().orElseThrow();
        if (parsedString.equals("always")) {
            return DataResult.success((Object)Float.valueOf(1.0f));
        }
        if (parsedString.equals("never")) {
            return DataResult.success((Object)Float.valueOf(0.0f));
        }
        return DataResult.error(() -> "Cannot parse %s as a chance, needs to be [0.0 - 1.0], 'always' or 'never'".formatted(parsedString));
    }

    private static Either<Float, String> createChanceEither(float chance) {
        if (chance >= 1.0f) {
            return Either.right((Object)"always");
        }
        if (chance <= 0.0f) {
            return Either.right((Object)"never");
        }
        return Either.left((Object)Float.valueOf(chance));
    }

    public static DataResult<Integer> getTimeFromEither(Either<Integer, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)((Integer)either.left().get()));
        }
        String[] split = ((String)either.right().orElseThrow()).split("s");
        if (split.length != 1) {
            return DataResult.error(() -> "Cannot parse %s as a time, needs to be [0 - %d] followed by 's'".formatted(either.right().orElseThrow(), 0x6666666));
        }
        try {
            int parsed = Integer.parseInt(split[0]);
            if (parsed < 0 || parsed >= 0x6666666) {
                return DataResult.error(() -> "Cannot parse %s as a time as seconds, needs to be [0 - %d] followed by 's'".formatted(split[0], 0x6666666));
            }
            return DataResult.success((Object)(parsed * 20));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Cannot parse %s as a time as seconds, needs to be [0 - %d] followed by 's'".formatted(split[0], 0x6666666));
        }
    }

    public static <T> Codec<List<T>> getSingleOrListCodec(Codec<T> single) {
        return Codec.withAlternative((Codec)single.listOf(), single, List::of);
    }

    public static <T, H extends Supplier<T>> Codec<T> withReplacementValues(Codec<T> single, Codec<H> replace, H[] possibleReplacements) {
        return Codec.either(replace, single).xmap(CodecUtils::getFromEitherWithReplacement, value -> CodecUtils.createEitherWithReplacement((Object)value, (Supplier[])possibleReplacements));
    }

    private static <T, H extends Supplier<T>> T getFromEitherWithReplacement(Either<H, T> either) {
        if (either.left().isPresent()) {
            return ((Supplier)either.left().get()).get();
        }
        return either.right().orElseThrow();
    }

    private static <T, H extends Supplier<T>> Either<H, T> createEitherWithReplacement(T value, H[] possibleRedirects) {
        for (H red : possibleRedirects) {
            if (!red.get().equals(value)) continue;
            return Either.left(red);
        }
        return Either.right(value);
    }

    public static <E extends EffectHolder> Products.P3<RecordCodecBuilder.Mu<E>, Holder<MobEffect>, Integer, Integer> addEffectAnd() {
        return CodecUtils.addEffectAnd(null);
    }

    public static <E extends EffectHolder> Products.P3<RecordCodecBuilder.Mu<E>, Holder<MobEffect>, Integer, Integer> addEffectAnd(@Nullable String prefix) {
        return new Products.P3((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(EffectHolder::effectHolder), (App)TIME_CODEC.optionalFieldOf((String)(prefix == null ? "duration" : prefix + "Duration"), (Object)0).forGetter(EffectHolder::duration), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf((String)(prefix == null ? "amplifier" : prefix + "Amplifier"), (Object)0).forGetter(EffectHolder::amplifier));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodecOptional(Codec<T> codec, String singularName) {
        return CodecUtils.singularOrPluralCodecOptional(codec, singularName, "%ss".formatted(singularName));
    }

    private static <T> MapCodec<Set<T>> singularOrPluralCodecOptional(Codec<T> codec, String singularName, String pluralName) {
        return Codec.mapEither((MapCodec)codec.fieldOf(singularName), (MapCodec)CodecUtils.setOf(codec).optionalFieldOf(pluralName, Set.of())).xmap(either -> (Set)either.map(ImmutableSet::of, ImmutableSet::copyOf), set -> set.size() == 1 ? Either.left(set.iterator().next()) : Either.right((Object)set));
    }

    private static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return Codec.list(codec).xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <T> Codec<T> byNameCodecWithDefaultModId(Registry<T> registry) {
        return CodecUtils.referenceHolderWithLifecycle(registry).flatComapMap(Holder.Reference::value, holder -> CodecUtils.safeCastToReference(registry, registry.wrapAsHolder(holder)));
    }

    private static <T> Codec<Holder.Reference<T>> referenceHolderWithLifecycle(Registry<T> registry) {
        Codec codec = CODEC_DEFAULT_MOD_ID.comapFlatMap(holder -> registry.getHolder(holder).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.key()) + ": " + String.valueOf(holder))), p_325513_ -> p_325513_.key().location());
        return ExtraCodecs.overrideLifecycle((Codec)codec, p_325514_ -> registry.registrationInfo(p_325514_.key()).map(RegistrationInfo::lifecycle).orElse(Lifecycle.experimental()));
    }

    private static <T> DataResult<Holder.Reference<T>> safeCastToReference(Registry<T> registry, Holder<T> holder) {
        DataResult dataResult;
        if (holder instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)holder;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(registry.key()) + ": " + String.valueOf(holder));
        }
        return dataResult;
    }

    private static DataResult<ResourceLocation> read(String input) {
        try {
            return DataResult.success((Object)CodecUtils.parse(input));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error(() -> "Not a valid resource location: " + input + " " + resourcelocationexception.getMessage());
        }
    }

    public static ResourceLocation parse(String input) {
        int i = input.indexOf(58);
        if (i >= 0) {
            String path = input.substring(i + 1);
            if (i != 0) {
                String modId = input.substring(0, i);
                return ResourceLocation.fromNamespaceAndPath((String)modId, (String)path);
            }
            return ResourceLocation.fromNamespaceAndPath((String)"csr", (String)path);
        }
        return ResourceLocation.fromNamespaceAndPath((String)"csr", (String)input);
    }

    private static String fromStringResourceLocation(ResourceLocation location) {
        if (location.getNamespace().equals("csr")) {
            return location.getPath();
        }
        return location.toString();
    }

    public static <T extends Enum<T>> StreamCodec<FriendlyByteBuf, T> createEnumStreamCodec(final Class<T> enumClass) {
        return new StreamCodec<FriendlyByteBuf, T>(){

            public void encode(FriendlyByteBuf o, T t) {
                o.writeEnum(t);
            }

            public T decode(FriendlyByteBuf byteBuf) {
                return byteBuf.readEnum(enumClass);
            }
        };
    }
}

