/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.util.ErrorHandler;

public class SoldierPropertyMapCodec
implements Codec<SoldierPropertyMap> {
    private static final Codec<SoldierPropertyType<?>> TYPE_CODEC = SoldierPropertyTypes.CODEC;
    private final Collection<Supplier<? extends SoldierPropertyType<?>>> ignored;

    public SoldierPropertyMapCodec(Collection<Supplier<? extends SoldierPropertyType<?>>> ignored) {
        this.ignored = ignored;
    }

    public SoldierPropertyMapCodec() {
        this(Set.of());
    }

    private <V> Codec<V> getSecond(SoldierPropertyType<V> type) {
        return type.getValueCodec();
    }

    public <T> DataResult<Pair<SoldierPropertyMap, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(ops, (MapLike)map)).map(spMap -> Pair.of((Object)spMap, (Object)input));
    }

    public <T> DataResult<SoldierPropertyMap> decode(DynamicOps<T> ops, MapLike<T> input) {
        List<SoldierPropertyType> toIgnore = this.ignored.stream().map(Supplier::get).toList();
        ImmutableMap.Builder read = ImmutableMap.builder();
        ImmutableList.Builder failed = ImmutableList.builder();
        DataResult result = input.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> {
            DataResult k = TYPE_CODEC.parse(ops, pair.getFirst());
            DataResult v = this.getSecond((SoldierPropertyType)k.result().orElseThrow()).parse(ops, pair.getSecond());
            DataResult entry = k.apply2stable(Pair::of, v);
            entry.error().ifPresent(e -> failed.add(pair));
            return r.apply2stable((u, p) -> {
                read.put((Object)((SoldierPropertyType)p.getFirst()), () -> ((Pair)p).getSecond());
                return u;
            }, entry);
        }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
        List<SoldierProperty> elements = read.build().entrySet().stream().map(entry -> SoldierPropertyMapCodec.createProperty((SoldierPropertyType)entry.getKey(), ((Supplier)entry.getValue()).get())).filter(p -> {
            boolean shouldIgnore = toIgnore.contains(p.type());
            if (shouldIgnore) {
                ErrorHandler.INSTANCE.error("Parsing a Soldier Property (%s), that should be ignored by the Codec".formatted(p));
            }
            return !shouldIgnore;
        }).toList();
        SoldierPropertyMap soldierPropertyMap = new SoldierPropertyMap(elements);
        ArrayList exceptions = new ArrayList();
        soldierPropertyMap.validate(e -> exceptions.add(e.getMessage()));
        if (!exceptions.isEmpty()) {
            return DataResult.error((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(exceptions));
        }
        Object errors = ops.createMap(failed.build().stream());
        return result.map(unit -> soldierPropertyMap).setPartial((Object)soldierPropertyMap).mapError(e -> e + " missed input: " + String.valueOf(errors));
    }

    public <T> DataResult<T> encode(SoldierPropertyMap input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    private <T> RecordBuilder<T> encode(SoldierPropertyMap input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        for (SoldierProperty<?> entry : input) {
            this.encodeSingle(entry, ops, prefix);
        }
        return prefix;
    }

    private <T, V> void encodeSingle(SoldierProperty<V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        prefix.add(TYPE_CODEC.encodeStart(ops, input.type()), this.getSecond(input.type()).encodeStart(ops, input.value()));
    }

    private static <T> SoldierProperty<T> createProperty(SoldierPropertyType<T> type, Object value) {
        return new SoldierProperty<Object>(type, value);
    }
}

