/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util.color;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class ColorHelper {
    public static final int DEFAULT_CLAY_COLOR = -6182991;
    public static final Codec<ColorHelper> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.string((int)4, (int)7)).comapFlatMap(ColorHelper::getFromEither, ColorHelper::convertToEither);
    public static final StreamCodec<ByteBuf, ColorHelper> STREAM_CODEC = ByteBufCodecs.either((StreamCodec)ByteBufCodecs.INT, (StreamCodec)ByteBufCodecs.STRING_UTF8).map(ColorHelper::new, ColorHelper::convertToEither);
    public static final ColorHelper EMPTY = ColorHelper.color(-1);
    public static final String JEB_NAME = "jeb_";
    private static final int MAGIC_NUMBER = 25;
    private static final String INT_COLOR_TAG = "color";
    private final int color;
    private final boolean jeb;

    public ColorHelper(int color, boolean jeb) {
        this.color = color;
        this.jeb = jeb;
    }

    private ColorHelper(Either<Integer, String> either) {
        this(either.left().orElse(-1), either.right().isPresent());
    }

    private static DataResult<ColorHelper> getFromEither(Either<Integer, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)ColorHelper.color((Integer)either.left().get()));
        }
        String name = (String)either.right().orElseThrow();
        if (name.equals(JEB_NAME)) {
            return DataResult.success((Object)ColorHelper.jeb());
        }
        if (name.matches("^#[0-9A-Fa-f]{6}$")) {
            return DataResult.success((Object)ColorHelper.color(Integer.parseInt(name.substring(1), 16)));
        }
        return DataResult.error(() -> "Invalid hex format. Expected format: #RRGGBB");
    }

    private Either<Integer, String> convertToEither() {
        return this.jeb ? Either.right((Object)JEB_NAME) : Either.left((Object)this.color);
    }

    public void writeToTag(String key, CompoundTag tag) {
        CompoundTag tagColor = new CompoundTag();
        if (this.color >= 0) {
            tagColor.putInt(INT_COLOR_TAG, this.color);
        }
        if (this.jeb) {
            tagColor.putBoolean(JEB_NAME, true);
        }
        tag.put(key, (Tag)tagColor);
    }

    public static ColorHelper getFromTag(String key, CompoundTag tag) {
        if (!tag.contains(key, 10)) {
            return EMPTY;
        }
        CompoundTag colorTag = tag.getCompound(key);
        return new ColorHelper(colorTag.contains(INT_COLOR_TAG, 99) ? colorTag.getInt(INT_COLOR_TAG) : -1, colorTag.contains(JEB_NAME));
    }

    public static ColorHelper jeb() {
        return new ColorHelper((Either<Integer, String>)Either.right((Object)JEB_NAME));
    }

    public static ColorHelper color(int color) {
        return new ColorHelper((Either<Integer, String>)Either.left((Object)color));
    }

    public String toString() {
        return "Color(" + this.color + (this.jeb ? ",jeb)" : ")");
    }

    private String format() {
        if (this.jeb) {
            return "Jeb_";
        }
        return String.format("#%06x", this.color & 0xFFFFFF).toUpperCase(Locale.ROOT);
    }

    public Component formatDynamic(LivingEntity entity) {
        return Component.literal((String)this.format()).withColor(this.getColor(entity, 0.0f));
    }

    public int getColor(LivingEntity entity, float pPartialTicks) {
        return this.getColor(entity.getId(), entity.tickCount, pPartialTicks);
    }

    public int getColor(int offset, int tickCount, float pPartialTicks) {
        if (this.jeb) {
            int k = tickCount / 25 + offset;
            int colorValues = DyeColor.values().length;
            int colorIdMin = k % colorValues;
            int colorIdMax = (k + 1) % colorValues;
            float lerp = ((float)(tickCount % 25) + pPartialTicks) / 25.0f;
            int min = Sheep.getColor((DyeColor)DyeColor.byId((int)colorIdMin));
            int max = Sheep.getColor((DyeColor)DyeColor.byId((int)colorIdMax));
            return FastColor.ARGB32.lerp((float)lerp, (int)min, (int)max);
        }
        return this.color;
    }

    public boolean isEmpty() {
        return !this.jeb && this.color <= -1;
    }

    public boolean isJeb() {
        return this.jeb;
    }

    public boolean hasStaticColor() {
        return this.color >= 0;
    }

    public int[] covertToRgb() {
        if (this.color <= -1) {
            return new int[0];
        }
        int red = this.color >> 16 & 0xFF;
        int green = this.color >> 8 & 0xFF;
        int blue = this.color & 0xFF;
        return new int[]{red, green, blue};
    }

    public int getColorStatic() {
        return this.color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorHelper that = (ColorHelper)o;
        return this.color == that.color && this.jeb == that.jeb;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.jeb);
    }

    public ColorHelper addColor(ColorHelper colorHelper) {
        if (this.color <= -1) {
            return new ColorHelper(colorHelper.color, this.jeb || colorHelper.jeb);
        }
        if (colorHelper.color <= -1) {
            return new ColorHelper(this.color, this.jeb || colorHelper.jeb);
        }
        return this.dyeColorHelper(colorHelper.covertToRgb(), this.jeb || colorHelper.jeb);
    }

    private ColorHelper dyeColorHelper(int[] colorAdded, boolean jeb) {
        int[] newColorArray = new int[3];
        int heightsValueOfEveryColorArray = 0;
        int[] currentColor = this.covertToRgb();
        int soldierRed = currentColor[0];
        int soldierGreen = currentColor[1];
        int soldierBlue = currentColor[2];
        heightsValueOfEveryColorArray += Math.max(soldierRed, Math.max(soldierGreen, soldierBlue));
        newColorArray[0] = newColorArray[0] + soldierRed;
        newColorArray[1] = newColorArray[1] + soldierGreen;
        newColorArray[2] = newColorArray[2] + soldierBlue;
        int dyeRed = colorAdded[0];
        int dyeGreen = colorAdded[1];
        int dyeBlue = colorAdded[2];
        newColorArray[0] = newColorArray[0] + dyeRed;
        newColorArray[1] = newColorArray[1] + dyeGreen;
        newColorArray[2] = newColorArray[2] + dyeBlue;
        return new ColorHelper(ColorHelper.getColorInt(newColorArray, heightsValueOfEveryColorArray += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue))), jeb);
    }

    private static int getColorInt(int[] newColorArray, float heightsValueOfEveryColorArray) {
        int newRed = newColorArray[0] / 2;
        int newGreen = newColorArray[1] / 2;
        int newBlue = newColorArray[2] / 2;
        float averageMaxValueOfEveryColor = heightsValueOfEveryColorArray / 2.0f;
        float maxAverageValue = Math.max(newRed, Math.max(newGreen, newBlue));
        newRed = (int)((float)newRed * averageMaxValueOfEveryColor / maxAverageValue);
        newGreen = (int)((float)newGreen * averageMaxValueOfEveryColor / maxAverageValue);
        newBlue = (int)((float)newBlue * averageMaxValueOfEveryColor / maxAverageValue);
        int colorInt = (newRed << 8) + newGreen;
        colorInt = (colorInt << 8) + newBlue;
        return colorInt;
    }
}

