/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.SimpleConfigFabric;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintManger;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.commands.ClaySoldierCommands;
import net.bumblebee.claysoldiers.commands.ColorHelperArgumentType;
import net.bumblebee.claysoldiers.commands.DefaultedResourceLocationArgument;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.ExternalMods;
import net.bumblebee.claysoldiers.integration.accessories.ModAccessories;
import net.bumblebee.claysoldiers.networking.ConfigSyncPayload;
import net.bumblebee.claysoldiers.networking.DataMapPayloadBuilder;
import net.bumblebee.claysoldiers.platform.FabricCapabilityManger;
import net.bumblebee.claysoldiers.platform.FabricCommonHooks;
import net.bumblebee.claysoldiers.platform.FabricDataMapGetter;
import net.bumblebee.claysoldiers.platform.FabricNetworkManger;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ClaySoldierFabric
implements ModInitializer {
    private static final class_2960 BLUEPRINT_ID = class_2960.method_60655((String)"csr", (String)"csr_blueprint");
    public static final class_2960 BLUEPRINT_PACK_ID = class_2960.method_60655((String)"csr", (String)"blueprint_pack");
    public static final class_2960 CSR_DEFAULT_PACK_ID = class_2960.method_60655((String)"csr", (String)"csr_default_datapack");
    public static final BlockApiLookup<BlueprintRequestHandler, Void> BLUEPRINT_REQUEST_HANDLER_LOOKUP = BlockApiLookup.get((class_2960)class_2960.method_60655((String)"csr", (String)"blueprint_request_handler"), BlueprintRequestHandler.class, Void.class);
    public static final BlockApiLookup<AssignablePoiCapability, Void> ASSIGNABLE_POI_LOOKUP = BlockApiLookup.get((class_2960)class_2960.method_60655((String)"csr", (String)"assignable_poi_capability"), AssignablePoiCapability.class, Void.class);
    public static long hamsterWheelCapacity = 3000L;
    public static long hamsterWheelSpeed = 3L;
    private final BlueprintTagLoad blueprintTagLoad = new BlueprintTagLoad();

    public void onInitialize() {
        ClaySoldiersCommon.init();
        FabricNetworkManger.forEachClient(data -> PayloadTypeRegistry.playS2C().register(data.id(), data.codec()));
        DataMapPayloadBuilder.registerAll();
        PayloadTypeRegistry.playS2C().register(ConfigSyncPayload.ID, ConfigSyncPayload.STREAM_CODEC);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(FabricDataMapGetter.FABRIC_ITEM_ID, FabricDataMapGetter::new);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricCapabilityManger());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(BLUEPRINT_ID, provider -> new IdentifiableResourceListenerWrapper(BLUEPRINT_ID, new BlueprintManger((class_7225<class_2248>)provider.method_46762(class_7924.field_41254), (class_7225<BlueprintData>)provider.method_46762(ModRegistries.BLUEPRINTS), this.blueprintTagLoad)));
        boolean blueprintPack = ResourceManagerHelperImpl.registerBuiltinResourcePack((class_2960)BLUEPRINT_PACK_ID, (String)"data/datapacks/blueprint_pack", (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("csr").orElseThrow()), (class_2561)class_2561.method_43471((String)ClaySoldiersCommon.BLUEPRINT_DATA_PACK_LANG), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        if (!blueprintPack) {
            ClaySoldiersCommon.LOGGER.error("Blueprint Pack count not be loaded");
        }
        if (!ResourceManagerHelperImpl.registerBuiltinResourcePack((class_2960)CSR_DEFAULT_PACK_ID, (String)"data/datapacks/csr_default_datapack", (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("csr").orElseThrow()), (class_2561)class_2561.method_43471((String)ClaySoldiersCommon.CSR_DEFAULT_DATA_PACK_LANG), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED)) {
            ClaySoldiersCommon.LOGGER.error("CSR Default Pack count not be loaded");
        }
        ClaySoldiersCommon.entityAttributes(FabricDefaultAttributeRegistry::register);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            ClaySoldiersCommon.playerJoinedServer(player, !joined);
            if (!player.field_13987.field_45013.method_10756()) {
                if (joined) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncPayload(FabricCommonHooks.isBlueprintEnabled(), hamsterWheelSpeed));
                }
                FabricDataMapGetter.sentPayloadsToClient(player);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(m -> {
            ClaySoldiersCommon.serverStartedEvent(m);
            FabricCommonHooks.setBlueprintEnabled(m.method_3836().method_29210().contains(BLUEPRINT_PACK_ID.toString()));
            ClaySoldiersCommon.LOGGER.info(FabricCommonHooks.isBlueprintEnabled() ? "Loaded BlueprintDataPack" : "Not loaded BlueprintDataPack");
            ClaySoldiersCommon.LOGGER.info("Loaded Datamaps: {}", FabricDataMapGetter.getLoadedDataMapsWithSize());
        });
        ClaySoldiersCommon.registerDynamicRegistry(new ClaySoldiersCommon.DynamicRegistryEvent(this){

            @Override
            public <T> void register(class_5321<class_2378<T>> registry, Codec<T> codec, @Nullable Codec<T> synced, @Nullable ClaySoldiersCommon.RegistryRegisteredCallBack<T> callback) {
                if (synced == null) {
                    DynamicRegistries.register(registry, codec);
                } else {
                    DynamicRegistries.registerSynced(registry, codec, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
                }
                if (callback != null) {
                    DynamicRegistrySetupCallback.EVENT.register(registryView -> registryView.registerEntryAdded(registry, callback::onRegister));
                }
            }
        });
        CommonLifecycleEvents.TAGS_LOADED.register((r, client) -> {
            ClaySoldiersCommon.onTagLoad(r, client);
            if (!client) {
                FabricDataMapGetter.onTagLoad(r);
                this.blueprintTagLoad.onTagLoad(r);
            }
        });
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)"csr", (String)"color_helper"), ColorHelperArgumentType.class, (class_2314)class_2319.method_41999(ColorHelperArgumentType::colorArgumentType));
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)"csr", (String)"all_clay_mob_teams"), DefaultedResourceLocationArgument.AllClayMobTeam.class, (class_2314)class_2319.method_41998(DefaultedResourceLocationArgument::all));
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)"csr", (String)"soldier_item_types"), DefaultedResourceLocationArgument.SoldierItemType.class, (class_2314)class_2319.method_41998(DefaultedResourceLocationArgument::itemType));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandBuildContext, commandSelection) -> ClaySoldierCommands.register((CommandDispatcher<class_2168>)commandDispatcher, commandBuildContext));
        ExternalMods.ACCESSORIES.ifLoaded(() -> ModAccessories::init);
        EnergyStorage.SIDED.registerForBlockEntities((BlockApiLookup.BlockEntityApiProvider)new BlockApiLookup.BlockEntityApiProvider<EnergyStorage, class_2350>(this){

            @Nullable
            public EnergyStorage find(class_2586 blockEntity, class_2350 context) {
                IHamsterWheelEnergyStorage en = HamsterWheelBlockEntity.getEnergyStorage(blockEntity, context);
                return en == null ? null : (EnergyStorage)en;
            }
        }, new class_2591[]{ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get()});
        BLUEPRINT_REQUEST_HANDLER_LOOKUP.registerForBlockEntities((BlockApiLookup.BlockEntityApiProvider)new BlockApiLookup.BlockEntityApiProvider<BlueprintRequestHandler, Void>(this){

            @Nullable
            public BlueprintRequestHandler find(class_2586 blockEntity, Void context) {
                BlueprintRequestHandler blueprintRequestHandler;
                if (blockEntity instanceof EaselBlockEntity) {
                    EaselBlockEntity easelBlockEntity = (EaselBlockEntity)blockEntity;
                    blueprintRequestHandler = easelBlockEntity.getBlueprintRequestHandler();
                } else {
                    blueprintRequestHandler = null;
                }
                return blueprintRequestHandler;
            }
        }, new class_2591[]{ModBlockEntities.EASEL_BLOCK_ENTITY.get()});
        ASSIGNABLE_POI_LOOKUP.registerForBlockEntities((BlockApiLookup.BlockEntityApiProvider)new BlockApiLookup.BlockEntityApiProvider<AssignablePoiCapability, Void>(this){

            @Nullable
            public AssignablePoiCapability find(class_2586 blockEntity, Void context) {
                AssignablePoiCapability assignablePoiCapability;
                if (blockEntity instanceof HamsterWheelBlockEntity) {
                    HamsterWheelBlockEntity wheel = (HamsterWheelBlockEntity)blockEntity;
                    assignablePoiCapability = wheel.getPoiCap();
                } else {
                    assignablePoiCapability = null;
                }
                return assignablePoiCapability;
            }
        }, new class_2591[]{ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get()});
        SimpleConfigFabric config = SimpleConfigFabric.of("csr").provider(namespace -> "# Whether the Inventory of a clay soldier can be edited via the menu. May cause loss of items.\nclaySoldierMenuModify=false\n# Hamster Wheel Capacity\nhamsterWheelCapacity=3000\n# Hamster Wheel Generation Speed\nhamsterWheelSpeed=1\n").request();
        if (config.isBroken()) {
            ClaySoldiersCommon.LOGGER.error("CSR Config: An Error occurred loading the {} Config File {}", (Object)"csr", (Object)config);
        } else {
            ClaySoldiersCommon.LOGGER.info("CSR Config: Successfully loaded on Server: {}", (Object)config.configValues());
        }
        ClaySoldiersCommon.claySolderMenuModify = config.getBoolean("claySoldierMenuModify", false);
        hamsterWheelCapacity = config.getPositiveLong("hamsterWheelCapacity", 3000L, BatteryProperty.getMaxSupportedEnergy(i -> Long.MAX_VALUE / (long)i));
        hamsterWheelSpeed = config.getPositiveLong("hamsterWheelSpeed", 3L, Long.MAX_VALUE);
    }

    private static class BlueprintTagLoad
    implements BiConsumer<BlueprintManger, class_3300> {
        private BlueprintManger manger;
        private class_3300 resourceManager;

        private BlueprintTagLoad() {
        }

        @Override
        public void accept(BlueprintManger manger, class_3300 resourceManager) {
            this.manger = manger;
            this.resourceManager = resourceManager;
        }

        public void onTagLoad(class_5455 registries) {
            this.manger.onTagLoad(this.resourceManager, ((class_6885.class_6888)registries.method_30530(class_7924.field_41254).method_40266(ModTags.Blocks.BLUEPRINT_BLACK_LISTED).orElseThrow()).method_40239().toList());
            this.manger = null;
            this.resourceManager = null;
        }
    }

    record IdentifiableResourceListenerWrapper(class_2960 location, class_4309 resourceReloadListener) implements IdentifiableResourceReloadListener
    {
        public class_2960 getFabricId() {
            return this.location;
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.resourceReloadListener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }
    }
}

