/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlockEntityRenderer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntityRenderer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelModel;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierCapeModel;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierShieldModel;
import net.bumblebee.claysoldiers.entity.client.boss.BossClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.boss.ClayBlockProjectileRenderer;
import net.bumblebee.claysoldiers.entity.client.boss.VampireBatRenderer;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseArmorLayer;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseModel;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseRenderer;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseWingsModel;
import net.bumblebee.claysoldiers.entity.client.horse.ClayPegasusRenderer;
import net.bumblebee.claysoldiers.entity.client.undead.VampireClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.undead.ZombieClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.wraith.WraithModel;
import net.bumblebee.claysoldiers.entity.client.wraith.WraithRenderer;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.blueprint.tooltip.BlueprintTooltip;
import net.bumblebee.claysoldiers.item.blueprint.tooltip.ClientBlueprintTooltip;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.item.claypouch.ClayPouchContent;
import net.bumblebee.claysoldiers.item.claypouch.ClientClayPouchTooltip;
import net.bumblebee.claysoldiers.item.claystaff.ClayStaffModel;
import net.bumblebee.claysoldiers.platform.services.IClientHooks;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_3300;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_953;
import org.jetbrains.annotations.Nullable;

public class ClaySoldiersClient {
    public static final IClientHooks CLIENT_HOOKS = ClaySoldiersCommon.load(IClientHooks.class);
    @Nullable
    public static ClayStaffModel clayStaffModel;

    public static boolean hasPlayerClayGogglesEquipped() {
        return ClaySoldiersCommon.IS_WEARING_GOGGLES.test((class_1657)class_310.method_1551().field_1724);
    }

    public static void registerModalLayers(BiConsumer<class_5601, Supplier<class_5607>> event) {
        event.accept(ClaySoldierModel.LAYER_LOCATION, ClaySoldierModel::createLayer);
        event.accept(ClaySoldierCapeModel.LAYER_LOCATION, ClaySoldierCapeModel::createSoldierMesh);
        event.accept(ClaySoldierShieldModel.LAYER_LOCATION, ClaySoldierShieldModel::createShieldLayer);
        event.accept(ClayBlockProjectileRenderer.LAYER_LOCATION, ClayBlockProjectileRenderer::createClayBlockLayer);
        event.accept(WraithModel.LAYER_LOCATION, WraithModel::createBodyLayer);
        event.accept(ClayHorseModel.LAYER_LOCATION, ClayHorseModel::createLayerDefinition);
        event.accept(ClayHorseWingsModel.LAYER_LOCATION, ClayHorseWingsModel::createBodyLayer);
        event.accept(ClayHorseArmorLayer.LAYER_LOCATION, ClayHorseModel::createLayerArmorDefinition);
        event.accept(HamsterWheelBlockEntityRenderer.POWER_LAYER_LOCATION, HamsterWheelBlockEntityRenderer::createPowerLayer);
        event.accept(HamsterWheelBlockEntityRenderer.STAND_LAYER_LOCATION, HamsterWheelBlockEntityRenderer::createStandLayer);
        event.accept(HamsterWheelBlockEntityRenderer.BatteryType.LEFT.getLayerLocation(), HamsterWheelBlockEntityRenderer.BatteryType.LEFT::createLayerDefinition);
        event.accept(HamsterWheelBlockEntityRenderer.BatteryType.RIGHT.getLayerLocation(), HamsterWheelBlockEntityRenderer.BatteryType.RIGHT::createLayerDefinition);
        event.accept(HamsterWheelModel.LAYER_LOCATION, HamsterWheelModel::createWheelLayer);
        event.accept(EaselBlockEntityRenderer.STAND_LAYER_LOCATION, EaselBlockEntityRenderer::createStandLayer);
        event.accept(EaselBlockEntityRenderer.BLUEPRINT_LAYER_LOCATION, EaselBlockEntityRenderer::createBlueprintLayer);
        event.accept(ClayStaffModel.LAYER_LOCATION, ClayStaffModel::createStaffLayer);
        event.accept(ClayStaffModel.SOLDIER_LAYER_LOCATION, ClayStaffModel::createSoldierDollLayer);
    }

    public static void registerBlockRenderers(BlockEntityRendererFactory event) {
        event.registerBlockEntityRenderer(ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), HamsterWheelBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntities.EASEL_BLOCK_ENTITY.get(), EaselBlockEntityRenderer::new);
    }

    public static void registerEntityRenderers(EntityRendererFactory event) {
        event.registerEntityRenderer(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), ClaySoldierRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), ZombieClaySoldierRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get(), VampireClaySoldierRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_HORSE_ENTITY.get(), ClayHorseRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_PEGASUS_ENTITY.get(), ClayPegasusRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_SOLDIER_THROWABLE_ITEM.get(), class_953::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_SOLDIER_POTION.get(), class_953::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_SOLDIER_SNOWBALL.get(), class_953::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_WRAITH.get(), WraithRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.VAMPIRE_BAT.get(), VampireBatRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), BossClaySoldierRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.CLAY_BLOCK_PROJECTILE.get(), ClayBlockProjectileRenderer::new);
    }

    public static void registerItemColorHandlers(BiConsumer<class_326, class_1935> event) {
        event.accept((pStack, pTintIndex) -> ClaySoldierSpawnItem.getColorFromTeam((class_2960)pStack.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), (class_1309)class_310.method_1551().field_1724), (class_1935)ModItems.CLAY_SOLDIER.get());
        event.accept((pStack, pTintIndex) -> {
            int color;
            if (pTintIndex != 1) {
                return -1;
            }
            ClayPouchContent content = (ClayPouchContent)pStack.method_57824(ModDataComponents.CLAY_POUCH_CONTENT.get());
            int n = color = content == null ? -1 : content.getColor((class_1309)class_310.method_1551().field_1724);
            if (color == -1) {
                return -6182991;
            }
            return class_5253.class_5254.method_57174((int)color);
        }, (class_1935)ModItems.CLAY_POUCH.get());
    }

    public static void registerItemInHandRenderers(Consumer<List<class_1935>> items) {
        items.accept(List.of(ModItems.CLAY_STAFF, ModBlocks.EASEL_BLOCK, ModBlocks.HAMSTER_WHEEL_BLOCK));
    }

    public static void registerEntityInsideShader(BiConsumer<class_1299<?>, class_2960> event) {
        event.accept(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get(), class_2960.method_60655((String)"csr", (String)"shaders/post/vampire.json"));
    }

    public static void registerTooltipComponent(ClientTooltipFactory event) {
        event.register(BlueprintTooltip.class, tooltip -> new ClientBlueprintTooltip(tooltip.requirements()));
        event.register(ClayPouchContent.class, ClientClayPouchTooltip::new);
    }

    public static void tooltipEvent(@Nullable class_1657 player, class_1799 stack, List<class_2561> tooltip) {
        if (player == null || !class_437.method_25443() && !CLIENT_HOOKS.hasSoldierTabOpen()) {
            return;
        }
        ComponentFormating.addHoldableTooltip(ClaySoldiersCommon.DATA_MAP.getEffect(stack), tooltip);
        ComponentFormating.addPoiTooltip(ClaySoldiersCommon.DATA_MAP.getItemPoi(stack), tooltip);
        ComponentFormating.addPoiTooltip(ClaySoldiersCommon.DATA_MAP.getBlockPoi(stack), tooltip);
        ClaySoldiersClient.addClayHorseTooltip(ClaySoldiersCommon.DATA_MAP.getHorseArmor(stack.method_7909()), tooltip);
    }

    public static void addClayHorseTooltip(@Nullable ClayHorseWearableProperties effect, List<class_2561> tooltip) {
        ComponentFormating.formatClayHorseProperties(effect, tooltip);
    }

    public static void reloadClayStaffModel(class_3300 resourceManager) {
        class_310 instance = class_310.method_1551();
        if (instance != null) {
            clayStaffModel = ClayStaffModel.create(arg_0 -> ((class_5599)instance.method_31974()).method_32072(arg_0));
        }
    }

    public static interface BlockEntityRendererFactory {
        public <T extends class_2586> void registerBlockEntityRenderer(class_2591<? extends T> var1, class_5614<T> var2);
    }

    public static interface EntityRendererFactory {
        public <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> var1, class_5617<T> var2);
    }

    public static interface ClientTooltipFactory {
        public <T extends class_5632> void register(Class<T> var1, Function<T, ? extends class_5684> var2);
    }
}

