/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import com.mojang.serialization.Codec;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintManger;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunctions;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicates;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.boss.BossBatEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.horse.ClayHorseEntity;
import net.bumblebee.claysoldiers.entity.horse.ClayPegasusEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModArmorMaterials;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModCreativeTab;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItemGenerators;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.bumblebee.claysoldiers.init.ModParticles;
import net.bumblebee.claysoldiers.init.ModPoiTypes;
import net.bumblebee.claysoldiers.init.ModRecipes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.networking.BlueprintClientPayload;
import net.bumblebee.claysoldiers.networking.BlueprintPlacePayload;
import net.bumblebee.claysoldiers.networking.CapabilityStatusPayload;
import net.bumblebee.claysoldiers.networking.ClayMobItemBreakParticles;
import net.bumblebee.claysoldiers.networking.ClaySoldierReviveCooldownPayload;
import net.bumblebee.claysoldiers.networking.ClayTeamPlayerDataPayload;
import net.bumblebee.claysoldiers.networking.HamsterWheelEnergyPayload;
import net.bumblebee.claysoldiers.networking.SoldierCarriedChangePayload;
import net.bumblebee.claysoldiers.networking.SoldierItemChangePayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayBossSpawnPayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayMobSpawnPayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClaySoldierSpawnPayload;
import net.bumblebee.claysoldiers.platform.services.AbstractCapabilityManger;
import net.bumblebee.claysoldiers.platform.services.ICommonHooks;
import net.bumblebee.claysoldiers.platform.services.IDataMapGetter;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.platform.services.IPlatformHelper;
import net.bumblebee.claysoldiers.soldieritemtypes.SoldierItemType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttacks;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1928;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaySoldiersCommon {
    public static final String MOD_ID = "csr";
    public static final String MOD_NAME = "Clay Soldiers Remake";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Remake");
    public static final String CLAY_SOLDIER_PROPERTY = "clay_soldier_property";
    public static final String CLAY_SOLDIER_PROPERTY_LANG = "clay_soldier_property.csr.";
    public static final IPlatformHelper PLATFORM = ClaySoldiersCommon.load(IPlatformHelper.class);
    public static final IDataMapGetter DATA_MAP = ClaySoldiersCommon.load(IDataMapGetter.class);
    public static final INetworkManger NETWORK_MANGER = ClaySoldiersCommon.load(INetworkManger.class);
    public static final ICommonHooks COMMON_HOOKS = ClaySoldiersCommon.load(ICommonHooks.class);
    public static final AbstractCapabilityManger CAPABILITY_MANGER = ClaySoldiersCommon.load(AbstractCapabilityManger.class);
    public static final class_1928.class_4313<class_1928.class_4312> CLAY_SOLDIER_DROP_RULE = PLATFORM.createIntRule("soldierDropThemSelf", class_1928.class_5198.field_24097, 50);
    public static final class_1928.class_4313<class_1928.class_4310> CLAY_SOLDIER_INVENTORY_DROP_RULE = PLATFORM.createBoolRule("soldierDropInventory", class_1928.class_5198.field_24097, true);
    public static final String CSR_DEFAULT_PACK_LOCATION = "data/datapacks";
    public static final String CSR_DEFAULT_DATA_PACK_PATH = "csr_default_datapack";
    public static final String CSR_DEFAULT_DATA_PACK_LANG = "resourcePack.%s.csr_default.name".formatted("csr");
    public static final String CSR_DEFAULT_PACK_DESCRIPTION = "datapack.%s.%s.description".formatted("csr", "csr_default_datapack");
    public static final String BLUEPRINT_PACK_PATH = "blueprint_pack";
    public static final String BLUEPRINT_DATA_PACK_LANG = "resourcePack.%s.blueprint.name".formatted("csr");
    public static final String BLUEPRINT_PACK_DESCRIPTION = "datapack.%s.%s.description".formatted("csr", "blueprint_pack");
    public static final String BLUEPRINT_PACK_SOURCE = "pack.source.%s.%s".formatted("csr", "blueprint_pack");
    public static Predicate<class_1657> IS_WEARING_GOGGLES = p -> p.method_6118(class_1304.field_6169).method_31574((class_1792)ModItems.CLAY_GOGGLES.get());
    @Nullable
    public static @Nullable Supplier<@Nullable class_1657> clientPlayer;
    public static boolean claySolderMenuModify;

    public static void init() {
        ModRegistries.init();
        ModItems.init();
        ModBlocks.init();
        ModBlockEntities.init();
        ModArmorMaterials.init();
        ModDataComponents.init();
        ModEffects.init();
        ModParticles.init();
        ModRecipes.init();
        ModEntityTypes.init();
        ModMenuTypes.init();
        ModCreativeTab.init();
        SoldierPropertyTypes.init();
        SpecialAttacks.init();
        ClayPoiFunctions.init();
        ClayPredicates.init();
        ModItemGenerators.init();
        ModBossBehaviours.init();
        ModPoiTypes.init();
        NETWORK_MANGER.registerS2CPayload(ClayMobItemBreakParticles.ID, ClayMobItemBreakParticles.STREAM_CODEC, ClayMobItemBreakParticles::handleClient);
        NETWORK_MANGER.registerS2CPayload(SoldierItemChangePayload.ID, SoldierItemChangePayload.STREAM_CODEC, SoldierItemChangePayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClaySoldierReviveCooldownPayload.ID, ClaySoldierReviveCooldownPayload.STREAM_CODEC, ClaySoldierReviveCooldownPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(SoldierCarriedChangePayload.ID, SoldierCarriedChangePayload.STREAM_CODEC, SoldierCarriedChangePayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Single.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_SINGLE, ClayTeamPlayerDataPayload.Single::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Remove.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_REMOVE, ClayTeamPlayerDataPayload.Remove::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Creation.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_CREATION, ClayTeamPlayerDataPayload.Creation::handleClient);
        NETWORK_MANGER.registerS2CPayload(BlueprintClientPayload.ID, BlueprintClientPayload.STREAM_CODEC, BlueprintClientPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(CapabilityStatusPayload.ID, CapabilityStatusPayload.STREAM_CODEC, CapabilityStatusPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(HamsterWheelEnergyPayload.ID, HamsterWheelEnergyPayload.STREAM_CODEC, HamsterWheelEnergyPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayMobSpawnPayload.ID, ClayMobSpawnPayload.STREAM_CODEC, ClayMobSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClaySoldierSpawnPayload.ID, ClaySoldierSpawnPayload.STREAM_CODEC, ClaySoldierSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayBossSpawnPayload.ID, ClayBossSpawnPayload.STREAM_CODEC, ClayBossSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(BlueprintPlacePayload.ID, BlueprintPlacePayload.STREAM_CODEC, BlueprintPlacePayload::handleClient);
    }

    public static void playerJoinsServerEvent(@Nullable class_3222 player, Stream<class_3222> relevantPlayers) {
        if (player != null) {
            ClaySoldiersCommon.playerJoinedServer(player, false);
        } else {
            relevantPlayers.forEach(serverPlayer -> ClaySoldiersCommon.playerJoinedServer(serverPlayer, true));
        }
    }

    public static void playerJoinedServer(class_3222 player, boolean reload) {
        ClaySoldiersCommon.sendWhenChannel(player, new ClayTeamPlayerDataPayload.Creation(TeamLoyaltyManger.getTeamData(player.method_51469()), reload), reload);
        if (!reload) {
            ClaySoldiersCommon.sendWhenChannel(player, new BlueprintClientPayload(BlueprintManger.getBlueprintShapeData(player.method_56673())), false);
        }
        if (NETWORK_MANGER.isMemoryConnection(player)) {
            LOGGER.info("No data PackSync Payloads will be send as the Connection is Memory for {}", (Object)player.method_5820());
            return;
        }
        ClaySoldiersCommon.sendWhenChannel(player, new CapabilityStatusPayload(AbstractCapabilityManger.getEnabledMap()), reload);
    }

    private static void sendWhenChannel(class_3222 serverPlayer, class_8710 payload, boolean reload) {
        if (NETWORK_MANGER.hasChannel(serverPlayer, payload.method_56479())) {
            NETWORK_MANGER.sendToPlayer(serverPlayer, payload);
            LOGGER.info("Sending {} to {} was {}", new Object[]{payload.method_56479().comp_2242(), serverPlayer.method_5820(), reload ? "reload" : "join"});
        } else {
            LOGGER.error("Could not send {} Packet to {} because there was no Channel", (Object)payload.method_56479().comp_2242(), (Object)serverPlayer.method_5820());
        }
    }

    public static void serverStartedEvent(MinecraftServer server) {
        LOGGER.info("TeamPlayerData on server: {}", (Object)TeamLoyaltyManger.getTeamPlayerData(server.method_30002()));
        LOGGER.info("Teams loaded: {}", ClayMobTeamManger.getAllKeys((class_7225.class_7874)server.method_30611()).toList());
    }

    public static void entityAttributes(BiConsumer<class_1299<? extends class_1309>, class_5132> event) {
        event.accept(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.CLAY_WRAITH.get(), ClayWraithEntity.setWraithAttributes());
        event.accept(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.CLAY_HORSE_ENTITY.get(), ClayHorseEntity.createBaseHorseAttributes());
        event.accept(ModEntityTypes.CLAY_PEGASUS_ENTITY.get(), ClayPegasusEntity.createPegasusAttributes());
        event.accept(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), BossClaySoldierEntity.bossAttributes());
        event.accept(ModEntityTypes.VAMPIRE_BAT.get(), BossBatEntity.createBatAttributes());
    }

    public static void registerDynamicRegistry(DynamicRegistryEvent event) {
        event.register(ModRegistries.BLUEPRINTS, BlueprintData.JSON_CODEC, BlueprintData.JSON_CODEC);
        event.register(ModRegistries.SOLDIER_ITEM_TYPES, SoldierItemType.CODEC, null, (id, location, value) -> value.onRegister(location));
        event.register(ModRegistries.CLAY_MOB_TEAMS, ClayMobTeam.CODEC_JSON, ClayMobTeam.CODEC_JSON, (id, key, value) -> ClayMobTeamManger.appendFromItemMap(value.getGetFrom(), key));
    }

    public static void onTagLoad(class_5455 registryAccess, boolean client) {
        if (!client) {
            class_2378 reg = registryAccess.method_30530(ModRegistries.SOLDIER_ITEM_TYPES);
            reg.forEach(type -> type.onTagLoad(tag -> registryAccess.method_30530(class_7924.field_41197).method_40266(tag)));
            SoldierItemType.postTagLoad(reg.method_10220());
        }
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    static {
        claySolderMenuModify = false;
    }

    public static interface DynamicRegistryEvent {
        default public <T> void register(class_5321<class_2378<T>> registry, Codec<T> codec, @Nullable Codec<T> synced) {
            this.register(registry, codec, synced, null);
        }

        public <T> void register(class_5321<class_2378<T>> var1, Codec<T> var2, @Nullable Codec<T> var3, RegistryRegisteredCallBack<T> var4);
    }

    public static interface RegistryRegisteredCallBack<T> {
        public void onRegister(int var1, class_2960 var2, T var3);
    }
}

