/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SimpleConfigFabric {
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private final HashMap<String, String> config = new HashMap();
    private final ConfigRequest request;
    private boolean broken = false;

    public static ConfigRequest of(String filename) {
        Path path = FabricLoader.getInstance().getConfigDir();
        return new ConfigRequest(path.resolve(filename + ".properties").toFile(), filename);
    }

    private void createConfig() throws IOException {
        this.request.file.getParentFile().mkdirs();
        Files.createFile(this.request.file.toPath(), new FileAttribute[0]);
        PrintWriter writer = new PrintWriter(this.request.file, StandardCharsets.UTF_8);
        writer.write(this.request.getConfig());
        writer.close();
    }

    private void loadConfig() throws IOException {
        Scanner reader = new Scanner(this.request.file);
        int line = 1;
        while (reader.hasNextLine()) {
            this.parseConfigEntry(reader.nextLine(), line);
            ++line;
        }
    }

    private void parseConfigEntry(String entry, int line) {
        if (!entry.isEmpty() && !entry.startsWith("#")) {
            String[] parts = entry.split("=", 2);
            if (parts.length == 2) {
                this.config.put(parts[0], parts[1]);
            } else {
                throw new RuntimeException("Syntax error in config file on line " + line + "!");
            }
        }
    }

    private SimpleConfigFabric(ConfigRequest request) {
        this.request = request;
        String identifier = "Config '" + request.filename + "'";
        if (!request.file.exists()) {
            LOGGER.info("{} is missing, generating default one...", (Object)identifier);
            try {
                this.createConfig();
            }
            catch (IOException e) {
                LOGGER.error("{} failed to generate!", (Object)identifier);
                LOGGER.trace(e.getMessage());
                this.broken = true;
            }
        }
        if (!this.broken) {
            try {
                this.loadConfig();
            }
            catch (Exception e) {
                LOGGER.error("{} failed to load!", (Object)identifier);
                LOGGER.trace(e.getMessage());
                this.broken = true;
            }
        }
    }

    public boolean getBoolean(String key, boolean def) {
        return this.getConfig(key, def, str -> {
            if (str.equalsIgnoreCase("true")) {
                return OptionalWithError.of(true);
            }
            if (str.equalsIgnoreCase("false")) {
                return OptionalWithError.of(false);
            }
            return OptionalWithError.empty(str + " cannot be parsed as boolean using the default %s");
        });
    }

    public long getPositiveLong(String key, long def, long max) {
        return this.getConfig(key, def, val -> {
            try {
                long value = Long.parseLong(val);
                if (value <= 0L) {
                    return OptionalWithError.empty(value + " is not positive using the default %s");
                }
                if (value > max) {
                    return OptionalWithError.partial(max, value + " is to big using the max: " + max);
                }
                return OptionalWithError.of(value);
            }
            catch (NumberFormatException e) {
                return OptionalWithError.empty(val + " cannot be parsed as long using the default %s");
            }
        });
    }

    private <T> T getConfig(String key, T def, Function<String, OptionalWithError<T>> getValue) {
        String val = this.config.get(key);
        if (val != null) {
            return getValue.apply(val).orElseGetAndDo(def, err -> LOGGER.warn("CSR Config: Error reading Config for {}: {}", (Object)key, err));
        }
        LOGGER.warn("CSR Config: No Value present for {}, using the default value {}", (Object)key, def);
        return def;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public String configValues() {
        StringBuilder builder = new StringBuilder();
        String seperator = "";
        builder.append("[");
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            builder.append(seperator);
            seperator = ", ";
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        builder.append("]");
        return builder.toString();
    }

    public String toString() {
        return "SimpleConfigFabric " + this.request.filename + ": " + String.valueOf(this.config) + (this.broken ? " broken" : "");
    }

    public static class ConfigRequest {
        private final File file;
        private final String filename;
        private DefaultConfig provider;

        private ConfigRequest(File file, String filename) {
            this.file = file;
            this.filename = filename;
            this.provider = DefaultConfig::empty;
        }

        public ConfigRequest provider(DefaultConfig provider) {
            this.provider = provider;
            return this;
        }

        public SimpleConfigFabric request() {
            return new SimpleConfigFabric(this);
        }

        private String getConfig() {
            return this.provider.get(this.filename) + "\n";
        }
    }

    private record OptionalWithError<T>(@Nullable T value, @Nullable String error) {
        public static <T> OptionalWithError<T> of(@NotNull T value) {
            return new OptionalWithError<T>(value, null);
        }

        public static <T> OptionalWithError<T> empty(@NotNull String error) {
            return new OptionalWithError<Object>(null, error);
        }

        public static <T> OptionalWithError<T> partial(@NotNull T value, @NotNull String error) {
            return new OptionalWithError<T>(value, error);
        }

        public T orElseGetAndDo(T other, Consumer<String> actionErrorPresent) {
            if (this.error != null) {
                actionErrorPresent.accept(this.error.formatted(other));
            }
            return this.value != null ? this.value : other;
        }
    }

    public static interface DefaultConfig {
        public String get(String var1);

        public static String empty(String namespace) {
            return "";
        }
    }
}

