/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.blueprint;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlock;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintManger;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ClientBlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.networking.BlueprintPlacePayload;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EaselBlockEntity
extends class_2586 {
    private static final String INDICATE_TAG_ON_CLIENT = "Client";
    private static final String MIRROR_TAG = "mirror";
    private static final String TEMPLATE_TAG = "template";
    @Nullable
    private BlueprintData data;
    @Nullable
    private BlueprintPlan template;
    private final BlueprintRequestHandler blueprintRequestHandler = new BlueprintRequestHandler(){

        @Override
        @Nullable
        public BlueprintRequest getRequest(Predicate<class_2338> canReach) {
            return EaselBlockEntity.this.getBlueprintRequest(canReach);
        }

        @Override
        public boolean doRequest(@Nullable BlueprintRequest request) {
            return EaselBlockEntity.this.doBlueprintRequest(request);
        }
    };
    private class_2415 mirror = class_2415.field_11302;

    public EaselBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlockEntities.EASEL_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public List<String> getInfoState() {
        ArrayList<String> info = new ArrayList<String>(3);
        info.add("Data: " + String.valueOf(this.data));
        info.add("Template: " + String.valueOf(this.template));
        info.add("Settings: " + String.valueOf(this.getTemplateSettings()));
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            info.add("Blueprint Cap: " + String.valueOf(ClaySoldiersCommon.CAPABILITY_MANGER.createPoiCache(serverLevel, this.field_11867)));
        }
        return info;
    }

    public void setBlueprintData(@NotNull BlueprintData data) {
        this.data = data;
        this.template = !this.field_11863.method_8608() ? (BlueprintPlan)data.createServerPlan().orElseThrow(IllegalArgumentException::new) : data.createClientPlan().orElseThrow(IllegalArgumentException::new);
        this.method_5431();
    }

    public void clearBlueprintData() {
        this.data = null;
        this.template = null;
        this.method_5431();
    }

    public class_1799 getBlueprintItem() {
        return BlueprintManger.createBlueprintItem(this.data, this.field_11863.method_30349());
    }

    public boolean hasBlueprintData() {
        return this.data != null;
    }

    @Nullable
    public BlueprintData getBlueprintData() {
        return this.data;
    }

    public List<class_1799> getRequiredItems() {
        return this.template == null ? List.of() : this.template.getNeededItems();
    }

    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11007(pTag, pRegistries);
        if (this.data != null) {
            this.data.save(pTag, pRegistries);
        }
        if (pTag.method_10545(INDICATE_TAG_ON_CLIENT)) {
            if (this.template != null) {
                this.template.saveItems(pTag);
                this.template.saveSize(pTag);
                this.template.saveHasStarted(pTag);
            } else {
                pTag.method_10551(INDICATE_TAG_ON_CLIENT);
            }
        } else {
            BlueprintPlan blueprintPlan = this.template;
            if (blueprintPlan instanceof ServerBlueprintPlan) {
                ServerBlueprintPlan serverTemplate = (ServerBlueprintPlan)blueprintPlan;
                class_2487 templateTag = new class_2487();
                pTag.method_10566(TEMPLATE_TAG, (class_2520)serverTemplate.save(templateTag));
            }
        }
        this.saveMirror(pTag);
    }

    protected void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        this.data = BlueprintData.load(pTag, pRegistries);
        if (pTag.method_10545(INDICATE_TAG_ON_CLIENT)) {
            this.template = new ClientBlueprintPlan(pTag);
        } else if (pTag.method_10545(TEMPLATE_TAG)) {
            this.template = ServerBlueprintPlan.load(pTag.method_10562(TEMPLATE_TAG), pRegistries);
        }
        this.loadMirror(pTag);
    }

    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        class_2487 tag = new class_2487();
        tag.method_10556(INDICATE_TAG_ON_CLIENT, true);
        this.method_11007(tag, pRegistries);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    private void saveMirror(class_2487 tag) {
        tag.method_10582(MIRROR_TAG, this.mirror.toString());
    }

    private void loadMirror(class_2487 tag) {
        try {
            this.mirror = class_2415.valueOf((String)tag.method_10558(MIRROR_TAG));
        }
        catch (IllegalArgumentException ignored) {
            this.mirror = class_2415.field_11302;
        }
    }

    public boolean cycleMirror() {
        if (this.hasStarted()) {
            return false;
        }
        this.mirror = this.mirror == class_2415.field_11302 ? class_2415.field_11301 : class_2415.field_11302;
        return true;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public boolean hasStarted() {
        return this.template != null && this.template.hasStarted();
    }

    public boolean isFinished() {
        return this.template != null && this.template.isFinished();
    }

    @Nullable
    public BlueprintTemplateSettings getTemplateSettings() {
        if (this.template == null) {
            return null;
        }
        return new BlueprintTemplateSettings(this.template.getSize(), this.mirror, EaselBlockEntity.fromDirection(this.getFacing()));
    }

    public class_2350 getFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)EaselBlock.FACING);
    }

    private static class_2470 fromDirection(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> class_2470.field_11467;
            case class_2350.field_11034 -> class_2470.field_11463;
            case class_2350.field_11035 -> class_2470.field_11464;
            case class_2350.field_11039 -> class_2470.field_11465;
            default -> throw new IllegalStateException("Easel Block Entity should never have a BlockState Facing of:" + String.valueOf(direction));
        };
    }

    @Nullable
    private BlueprintRequest getBlueprintRequest(Predicate<class_2338> canReachDestination) {
        if (this.template == null || this.template.isFinished()) {
            return null;
        }
        BlueprintTemplateSettings settings = this.getTemplateSettings();
        BlueprintRequest request = ((ServerBlueprintPlan)this.template).getRequest((class_3218)this.field_11863, this.getTemplateBase(settings), this.getTemplateSettings(), canReachDestination);
        if (request != null && !canReachDestination.test(request.getPos())) {
            request.cancel();
            return null;
        }
        return request;
    }

    private class_2338 getTemplateBase(BlueprintTemplateSettings settings) {
        return this.field_11867.method_10081((class_2382)class_2338.field_10980.method_10079(this.getFacing().method_10153(), 2).method_10079(this.getFacing().method_10170(), settings.getDistanceToCenter()));
    }

    private boolean doBlueprintRequest(BlueprintRequest request) {
        if (request == null) {
            return false;
        }
        return this.tryPlacingSoldier(request.getItem().method_7854()).isSuccess();
    }

    public BlueprintPlan.PlaceResult tryPlacingSoldier(class_1799 item) {
        if (this.template == null) {
            return BlueprintPlan.PlaceResult.NOT_NEEDED;
        }
        BlueprintTemplateSettings settings = this.getTemplateSettings();
        BlueprintPlan.PlaceResult result = this.template.tryPlacing(this.field_11863, item, this.getTemplateBase(settings), settings);
        if (result.isSuccess()) {
            if (!this.field_11863.method_8608()) {
                ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingBlockEntity(this, new BlueprintPlacePayload(this.field_11867, item.method_7909()));
            }
            this.method_5431();
        }
        return result;
    }

    public BlueprintRequestHandler getBlueprintRequestHandler() {
        return this.blueprintRequestHandler;
    }

    public String toString() {
        String levelName = this.field_11863 != null ? (this.field_11863.method_8608() ? INDICATE_TAG_ON_CLIENT : "Server") : "Null";
        return "EaselBlockEntity(%s, %s)".formatted(levelName, this.method_11016());
    }
}

