/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import com.mojang.serialization.MapCodec;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModTags;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<BatteryProperty> BATTERY_PROPERTY = class_2754.method_11850((String)"battery", BatteryProperty.class);
    private static final class_265 SHAPE_WEST = class_2248.method_9541((double)5.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_EAST = class_2248.method_9541((double)1.0, (double)0.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)11.0);
    private static final class_265 SHAPE_NORTH = class_2248.method_9541((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)15.0);
    private static final class_265 SHAPE_POWERED_WEST = class_2248.method_9541((double)5.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_POWERED_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_POWERED_SOUTH = class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)11.0);
    private static final class_265 SHAPE_POWERED_NORTH = class_2248.method_9541((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)16.0);
    private static final MapCodec<HamsterWheelBlock> CODEC = HamsterWheelBlock.method_54094(HamsterWheelBlock::new);

    public HamsterWheelBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.NONE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(new class_2769[]{FACING, BATTERY_PROPERTY});
    }

    protected class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        if (HamsterWheelBlock.hasPowerConnection(pState)) {
            return HamsterWheelBlock.getVoxelShape(pState, SHAPE_POWERED_NORTH, SHAPE_POWERED_SOUTH, SHAPE_POWERED_EAST, SHAPE_POWERED_WEST);
        }
        return HamsterWheelBlock.getVoxelShape(pState, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_EAST, SHAPE_WEST);
    }

    private static class_265 getVoxelShape(class_2680 pState, class_265 shapeNorth, class_265 shapeSouth, class_265 shapeEast, class_265 shapeWest) {
        return switch ((class_2350)pState.method_11654((class_2769)FACING)) {
            case class_2350.field_11043 -> shapeNorth;
            case class_2350.field_11035 -> shapeSouth;
            case class_2350.field_11034 -> shapeEast;
            case class_2350.field_11039 -> shapeWest;
            default -> throw new IllegalStateException("Direction should never be any other than N,E,S,W");
        };
    }

    protected class_9062 method_55765(class_1799 pStack, class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHitResult) {
        if (pStack.method_31574(class_1802.field_8725)) {
            if (pState.method_11654(BATTERY_PROPERTY) == BatteryProperty.NONE) {
                pLevel.method_8652(pPos, (class_2680)pState.method_11657(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.SINGLE)), 3);
                pStack.method_57008(1, (class_1309)pPlayer);
                return class_9062.method_55644((boolean)pLevel.method_8608());
            }
            if (pState.method_11654(BATTERY_PROPERTY) == BatteryProperty.SINGLE) {
                pLevel.method_8652(pPos, (class_2680)pState.method_11657(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.DUAL)), 3);
                pStack.method_57008(1, (class_1309)pPlayer);
                return class_9062.method_55644((boolean)pLevel.method_8608());
            }
        }
        if (pStack.method_31573(ModTags.Items.WRENCH)) {
            pLevel.method_8652(pPos, this.method_9598(pState, class_2470.field_11463), 3);
            return class_9062.method_55644((boolean)pLevel.method_8608());
        }
        return class_9062.field_47731;
    }

    protected class_1269 method_55766(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_3965 pHitResult) {
        HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)pLevel.method_8321(pPos);
        if (hamsterWheelBlockEntity.hasSoldier()) {
            hamsterWheelBlockEntity.spawnSoldier(7);
            hamsterWheelBlockEntity.method_5431();
            return class_1269.method_29236((boolean)pLevel.method_8608());
        }
        return class_1269.field_5811;
    }

    public static boolean hasPowerConnection(class_2680 state) {
        return state.method_11654(BATTERY_PROPERTY) != BatteryProperty.NONE;
    }

    protected void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pMovedByPiston) {
        if (!pState.method_27852(pNewState.method_26204())) {
            class_2586 class_25862 = pLevel.method_8321(pPos);
            if (class_25862 instanceof HamsterWheelBlockEntity) {
                HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)class_25862;
                hamsterWheelBlockEntity.spawnSoldier(0);
            }
            if (HamsterWheelBlock.hasPowerConnection(pState)) {
                class_1264.method_5449((class_1937)pLevel, (double)pPos.method_10263(), (double)pPos.method_10264(), (double)pPos.method_10260(), (class_1799)class_1802.field_8725.method_7854());
            }
        }
        super.method_9536(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected MapCodec<? extends HamsterWheelBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new HamsterWheelBlockEntity(pPos, pState);
    }

    protected class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRot.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    protected class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9605(class_1750 pContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)pContext.method_8042().method_10153());
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 ? null : HamsterWheelBlock.method_31618(blockEntityType, ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), (level1, blockPos, blockState, hamsterWheelBlockEntity) -> hamsterWheelBlockEntity.serverTick());
    }
}

