/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.ClayMobContainer;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.networking.HamsterWheelEnergyPayload;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8080;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlockEntity
extends class_2586
implements ClayMobContainer {
    public static final Map<class_5321<class_1937>, Collection<String>> withSoldiers = new HashMap<class_5321<class_1937>, Collection<String>>();
    private final class_8080 walkAnimation = new class_8080();
    private final IHamsterWheelEnergyStorage energyStorage;
    private final AssignablePoiCapability poiCap = new AssignablePoiCapability(){

        @Override
        public boolean canUse(ClayMobEntity clayMob) {
            AbstractClaySoldierEntity soldier;
            return clayMob instanceof AbstractClaySoldierEntity && (soldier = (AbstractClaySoldierEntity)clayMob).getSoldierSize() <= 1.45f;
        }

        @Override
        public void use(ClayMobEntity clayMob) {
            if (!(clayMob instanceof AbstractClaySoldierEntity)) {
                throw new IllegalArgumentException(String.valueOf(clayMob) + " cannot use this poi");
            }
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)clayMob;
            HamsterWheelBlockEntity.this.addSoldier(soldier);
        }
    };
    @Nullable
    private HamsterWheelSoldierData soldierData = null;
    private long lastEnergySend = 0L;
    private int rotationTick = 0;

    public HamsterWheelBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.energyStorage = ClaySoldiersCommon.CAPABILITY_MANGER.createEnergyStorage(this);
    }

    public void clientTick(float partialTick) {
        if (this.hasSoldier()) {
            this.rotationTick += (int)Math.clamp(this.soldierData.getSpeed(), 1.0f, 3.0f);
            ++this.soldierData.getClientSoldier().field_6012;
            float f = Math.min(partialTick * 4.0f, 1.0f);
            this.walkAnimation.method_48568(f, 0.4f);
        }
    }

    public float getRotationTick(float partialTick) {
        return (float)this.rotationTick + (this.hasSoldier() ? partialTick : 0.0f);
    }

    public boolean hasSoldier() {
        return this.soldierData != null;
    }

    @Nullable
    public HamsterWheelSoldierData getSoldierData() {
        return this.soldierData;
    }

    private void addSoldier(AbstractClaySoldierEntity soldier) {
        this.spawnSoldier(0);
        soldier.method_5848();
        soldier.method_5772();
        soldier.dropCarried();
        this.setSoldierData(HamsterWheelSoldierData.of(soldier), 7);
        soldier.method_31472();
    }

    public AssignablePoiCapability getPoiCap() {
        return this.poiCap;
    }

    @Nullable
    public IHamsterWheelEnergyStorage getEnergyStorage(@Nullable class_2350 direction) {
        if (this.hasEnergyStorage()) {
            if (direction == null) {
                return this.energyStorage.asViewOnly();
            }
            return direction.method_10153() == this.method_11010().method_11654((class_2769)HamsterWheelBlock.FACING) ? this.energyStorage : null;
        }
        return null;
    }

    @Nullable
    public static IHamsterWheelEnergyStorage getEnergyStorage(class_2586 blockEntity, class_2350 context) {
        if (blockEntity instanceof HamsterWheelBlockEntity) {
            HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)blockEntity;
            return hamsterWheelBlockEntity.getEnergyStorage(context);
        }
        return null;
    }

    public boolean hasEnergyStorage() {
        return HamsterWheelBlock.hasPowerConnection(this.method_11010());
    }

    public boolean hasSecondBattery() {
        return this.method_11010().method_11654(HamsterWheelBlock.BATTERY_PROPERTY) == BatteryProperty.DUAL;
    }

    public int getEnergyCapacityMultiplier() {
        return ((BatteryProperty)((Object)this.method_11010().method_11654(HamsterWheelBlock.BATTERY_PROPERTY))).getCapacityMultiplier();
    }

    public void spawnSoldier(int flags) {
        if (this.hasSoldier()) {
            if (!this.method_10997().field_9236) {
                AbstractClaySoldierEntity soldier = this.soldierData.createSoldier(this.method_10997());
                soldier.method_29495(this.getExitPosition());
                soldier.method_6033(soldier.method_6063());
                this.method_10997().method_8649((class_1297)soldier);
            }
            this.setSoldierData(null, flags);
        }
    }

    public class_243 getExitPosition() {
        class_2338 pos = this.field_11867;
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)HamsterWheelBlock.FACING);
        return new class_243((double)pos.method_10263() + 0.5 + (double)((float)direction.method_10148() * 0.3f), (double)pos.method_10264(), (double)pos.method_10260() + 0.5 + (double)((float)direction.method_10165() * 0.3f));
    }

    private void setSoldierData(@Nullable HamsterWheelSoldierData data, int flags) {
        this.soldierData = data;
        if ((flags & 1) != 0) {
            this.method_5431();
        }
        if ((flags & 2) != 0) {
            this.method_10997().method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
        if ((flags & 4) != 0) {
            this.setOccupant(this.method_10997(), data);
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        try {
            this.setOccupant(level, this.soldierData);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void setOccupant(@Nullable class_1937 level, @Nullable HamsterWheelSoldierData data) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (data == null) {
                serverLevel.method_19494().method_19129(this.field_11867);
            } else {
                serverLevel.method_19494().method_19126(h -> h.method_40220(ModTags.PoiTypes.SOLDIER_CONTAINER), (h, p) -> p.equals((Object)this.field_11867), this.field_11867, 1);
            }
        }
    }

    @Override
    public void killSoldier(class_3218 level, class_1657 player) {
        if (this.soldierData == null) {
            return;
        }
        TeamPlayerData.PlayerData owner = TeamLoyaltyManger.getTeamPlayerData(level).getPlayerForTeam(this.soldierData.getTeamId());
        if (owner == null || owner.is(player)) {
            class_243 pos = this.getExitPosition();
            this.soldierData.dropItems(level, pos.field_1352, pos.field_1351, pos.field_1350);
            this.setSoldierData(null, 7);
            this.method_5431();
            level.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11007(pTag, pRegistries);
        if (this.soldierData != null) {
            this.soldierData.save(pTag);
        }
        this.energyStorage.save(pTag);
    }

    protected void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        this.setSoldierData(HamsterWheelSoldierData.load(pTag, this.method_11016(), this.walkAnimation, pRegistries), 0);
        this.energyStorage.load(pTag);
    }

    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        class_2487 tag = super.method_16887(pRegistries);
        HamsterWheelSoldierData.markTagAsClient(tag);
        this.method_11007(tag, pRegistries);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void serverTick() {
        if (this.hasEnergyStorage() && this.hasSoldier()) {
            this.energyStorage.generate(this.soldierData.getAdjustedSpeed());
        }
        if (this.hasEnergyStorage() && Math.abs(this.lastEnergySend - this.energyStorage.energyStored()) > 2L) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingBlockEntity(this, new HamsterWheelEnergyPayload(this.energyStorage.energyStored(), this.method_11016()));
            this.lastEnergySend = this.energyStorage.energyStored();
            this.method_5431();
        }
    }

    public String toString() {
        return "HamsterWheelBlockEntity(%s, %s)".formatted(this.field_11867.method_23854(), this.field_11863);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HamsterWheelBlockEntity entity = (HamsterWheelBlockEntity)o;
        return this.field_11867.equals((Object)entity.field_11867);
    }

    public int hashCode() {
        return this.field_11867.hashCode();
    }
}

