/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import java.util.function.Consumer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelModel;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class HamsterWheelBlockEntityRenderer
implements class_827<HamsterWheelBlockEntity> {
    private static final class_2960 HAMSTER_WHEEL_TEXTURE = class_2960.method_60655((String)"csr", (String)"textures/block/hamster_wheel.png");
    private static final class_2960 BATTERY_CONTENT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"block/water_still");
    private static final class_1921 RENDER_TYPE_BLOCK = class_1921.method_23578((class_2960)HAMSTER_WHEEL_TEXTURE);
    private static final float DEG_90 = 1.5707964f;
    private static final float WHEEL_SPEED = 0.1759292f;
    public static final class_5601 STAND_LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"csr", (String)"hamster_stand"), "main");
    public static final class_5601 POWER_LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"csr", (String)"hamster_power"), "main");
    private final class_630 stand;
    private final class_630 powerConnection;
    private final class_630 batteryLeft;
    private final class_630 batteryRight;
    private final HamsterWheelModel wheelModel;

    public HamsterWheelBlockEntityRenderer(class_5614.class_5615 pContext) {
        this.stand = pContext.method_32140(STAND_LAYER_LOCATION);
        this.powerConnection = pContext.method_32140(POWER_LAYER_LOCATION);
        this.wheelModel = new HamsterWheelModel(pContext.method_32140(HamsterWheelModel.LAYER_LOCATION));
        this.batteryLeft = pContext.method_32140(BatteryType.LEFT.getLayerLocation());
        this.batteryRight = pContext.method_32140(BatteryType.RIGHT.getLayerLocation());
    }

    public void render(HamsterWheelBlockEntity hamsterWheelBlock, float pPartialTick, class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        HamsterWheelSoldierData data;
        OptionalProfiler optProfiler = new OptionalProfiler(hamsterWheelBlock.method_10997());
        optProfiler.push("hamsterWheelRender");
        float yRot = ((class_2350)hamsterWheelBlock.method_11010().method_11654((class_2769)HamsterWheelBlock.FACING)).method_10153().method_10144();
        pPoseStack.method_46416(0.5f, 0.5f, 0.5f);
        pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(-yRot));
        pPoseStack.method_46416(-0.5f, -0.5f, -0.5f);
        class_4588 wheelBuilder = pBuffer.getBuffer(RENDER_TYPE_BLOCK);
        hamsterWheelBlock.clientTick(pPartialTick);
        this.stand.method_22699(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
        this.wheelModel.setUpRotation(hamsterWheelBlock.getRotationTick(pPartialTick) % 251.0f * 0.1759292f);
        this.wheelModel.method_2828(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
        if (hamsterWheelBlock.hasEnergyStorage()) {
            optProfiler.push("batteryRender");
            this.powerConnection.method_22699(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
            this.batteryLeft.method_22699(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_BLOCK), pPackedLight, pPackedOverlay, -1);
            HamsterWheelBlockEntityRenderer.renderBatterContent(hamsterWheelBlock, pBuffer, pPoseStack, pPackedLight);
            if (hamsterWheelBlock.hasSecondBattery()) {
                this.batteryRight.method_22699(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_BLOCK), pPackedLight, pPackedOverlay, -1);
                pPoseStack.method_22903();
                pPoseStack.method_46416(0.5625f, 0.0f, 0.0f);
                HamsterWheelBlockEntityRenderer.renderBatterContent(hamsterWheelBlock, pBuffer, pPoseStack, pPackedLight);
                pPoseStack.method_22909();
            }
            optProfiler.pop();
        }
        if ((data = hamsterWheelBlock.getSoldierData()) != null) {
            optProfiler.push("soldierRender");
            pPoseStack.method_46416(0.5f, 0.1f, 0.5f);
            pPoseStack.method_22907(class_7833.field_40716.rotation(1.5707964f));
            data.getClientSoldier().render(0.0f, pPartialTick, pPoseStack, pBuffer, pPackedLight);
            optProfiler.pop();
        }
        optProfiler.pop();
    }

    private static void renderBatterContent(HamsterWheelBlockEntity entity, class_4597 buffer, class_4587 pPoseStack, int pPackedLight) {
        IHamsterWheelEnergyStorage energy = entity.getEnergyStorage(null);
        if (energy == null || energy.energyStored() == 0L) {
            return;
        }
        float height = Math.max(0.1f, 6.0f * (float)energy.energyStored() / (float)energy.maxEnergyStored());
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(BATTERY_CONTENT_TEXTURE);
        class_4588 builder = buffer.getBuffer(class_310.method_29611() ? class_1921.method_23577() : class_1921.method_23583());
        float textureScale = height / 6.0f;
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        u1 = (u1 - u0) * 0.5f + u0;
        if (height <= 5.0f) {
            HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, height, 12, 5, height, 15, u0, v0, u1, (v1 - v0) * 0.5f + v0, pPackedLight);
        }
        if (height <= 1.0f) {
            return;
        }
        v1 = (v1 - v0) * textureScale + v0;
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, 0.0f, 12, 5, height, 12, u0, v0, u1, v1, pPackedLight);
        pPoseStack.method_22903();
        pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        pPoseStack.method_46416(-0.4375f, 0.0f, -1.875f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, 0.0f, 15, 5, height, 15, u0, v0, u1, v1, pPackedLight);
        pPoseStack.method_22909();
        pPoseStack.method_22903();
        pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        pPoseStack.method_46416(-1.6875f, 0.0f, 0.0f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 12, 0.0f, 2, 15, height, 2, u0, v0, u1, v1, pPackedLight);
        pPoseStack.method_22909();
        pPoseStack.method_22903();
        pPoseStack.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
        pPoseStack.method_46416(0.0f, 0.0f, -0.625f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 12, 0.0f, 5, 15, height, 5, u0, v0, u1, v1, pPackedLight);
        pPoseStack.method_22909();
    }

    private static void drawQuad(class_4588 builder, class_4587 poseStack, int x0, float y0, int z0, int x1, float y1, int z1, float u0, float v0, float u1, float v1, int packedLight) {
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x0 / 16.0f, y0 / 16.0f, (float)z0 / 16.0f, u0, v0, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x0 / 16.0f, y1 / 16.0f, (float)z1 / 16.0f, u0, v1, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x1 / 16.0f, y1 / 16.0f, (float)z1 / 16.0f, u1, v1, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x1 / 16.0f, y0 / 16.0f, (float)z0 / 16.0f, u1, v0, 0.0f, 1.0f, 0.0f, packedLight);
    }

    private static void drawVertex(class_4588 builder, class_4587 poseStack, float x, float y, float z, float u, float v, float n0, float n1, float n2, int packedLight) {
        builder.method_22918(poseStack.method_23760().method_23761(), x, y, z).method_39415(-146800668).method_22913(u, v).method_60803(packedLight).method_22914(n0, n1, n2);
    }

    public static class_5607 createStandLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        class_5610 stand = partdefinition.method_32117("stand", class_5606.method_32108().method_32101(14, 15).method_32097(-1.0f, -3.1715f, 0.5f, 2.0f, 9.0f, 2.0f).method_32101(0, 0).method_32097(-2.0f, 5.3285f, -3.501f, 4.0f, 1.0f, 7.0f), class_5603.method_32091((float)8.0f, (float)6.1715f, (float)11.5f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        return class_5607.method_32110((class_5609)meshdefinition, (int)32, (int)32);
    }

    public static class_5607 createPowerLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        partdefinition.method_32117("power_connection", class_5606.method_32108().method_32101(0, 8).method_32097(-4.0f, -12.0f, 7.999f, 8.0f, 8.0f, 0.0f).method_32101(16, 8).method_32097(-3.0f, -11.0f, 6.997f, 6.0f, 6.0f, 1.0f).method_32101(6, 21).method_32097(0.5f, -6.0f, 6.998f, 1.0f, 6.0f, 1.0f).method_32101(0, 0).method_32097(-1.5f, -6.0f, 6.998f, 1.0f, 6.0f, 1.0f).method_32101(24, 15).method_32097(-0.75f, -8.535f, 6.0f, 1.0f, 1.0f, 1.0f), class_5603.method_32091((float)8.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        return class_5607.method_32110((class_5609)meshdefinition, (int)32, (int)32);
    }

    private static class_5607 createBatteryBase(BatteryType type) {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        partdefinition.method_32117(type.name, class_5606.method_32108().method_32101(20, 23).method_32098(-2.0f, -6.01f, -1.0f, 3.0f, 6.0f, 3.0f, new class_5605(0.01f)).method_32101(8, 30).method_32097(-1.0f, -6.5f, 0.0f, 1.0f, 1.0f, 1.0f).method_32101(4, 30).method_32097(-3.011f, -0.75f, -0.75f, 1.0f, 1.0f, 1.0f).method_32101(0, 30).method_32097(-3.011f, -0.75f, 0.75f, 1.0f, 1.0f, 1.0f), type.offsetAndRot);
        return class_5607.method_32110((class_5609)meshdefinition, (int)32, (int)32);
    }

    public static enum BatteryType {
        LEFT("battery_left", class_5603.method_32091((float)3.0f, (float)0.001f, (float)13.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI))),
        RIGHT("battery_right", class_5603.method_32091((float)13.0f, (float)0.001f, (float)14.0f, (float)0.0f, (float)((float)Math.PI), (float)((float)Math.PI)));

        private final String name;
        private final class_5603 offsetAndRot;
        private final class_5601 layerLocation;

        private BatteryType(String name, class_5603 offsetAndRot) {
            this.name = name;
            this.offsetAndRot = offsetAndRot;
            this.layerLocation = new class_5601(class_2960.method_60655((String)"csr", (String)(name + "_layer")), "main");
        }

        public class_5601 getLayerLocation() {
            return this.layerLocation;
        }

        public class_5607 createLayerDefinition() {
            return HamsterWheelBlockEntityRenderer.createBatteryBase(this);
        }
    }

    private static class OptionalProfiler {
        private static final Consumer<String> PUSH_EMPTY = s -> {};
        private static final Runnable POP_EMPTY = () -> {};
        private final Runnable pop;
        private final Consumer<String> push;

        public OptionalProfiler(class_1937 level) {
            if (level == null) {
                this.pop = POP_EMPTY;
                this.push = PUSH_EMPTY;
            } else {
                class_3695 profiler = level.method_16107();
                this.push = arg_0 -> ((class_3695)profiler).method_15396(arg_0);
                this.pop = () -> ((class_3695)profiler).method_15407();
            }
        }

        private void push(String name) {
            this.push.accept(name);
        }

        private void pop() {
            this.pop.run();
        }
    }
}

