/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.client.ClientClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8080;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HamsterWheelSoldierData {
    private static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = class_7923.field_41177.method_39673();
    private static final List<String> IGNORED_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "Health", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "id", "Passengers", "leash", "Sitting", "Fuse", "ignited", "ExplosionRadius", "PoiPos", "CarriedItem", "team_id");
    private static final List<String> CLIENT_NEEDED_TAGS = Arrays.asList("SoldierBackpackItems", "SoldierHandItems", "SoldierArmorItems", "OffsetColor", "SkinVariantId", "Waxed");
    private static final String ACTIVE_EFFECTS_TAG = "active_effects";
    private static final class_9139<class_9129, class_1299<?>> STREAM_CODEC_ENTITY_TYPE = class_9135.method_56365((class_5321)class_7924.field_41266);
    public static final class_9139<class_9129, HamsterWheelSoldierData> STREAM_CODEC_CLIENT = new class_9139<class_9129, HamsterWheelSoldierData>(){

        public HamsterWheelSoldierData decode(class_9129 registryFriendlyByteBuf) {
            return HamsterWheelSoldierData.createUnsafe((class_1299)STREAM_CODEC_ENTITY_TYPE.decode((Object)registryFriendlyByteBuf), (class_2960)class_2960.field_48267.decode((Object)registryFriendlyByteBuf), (class_2487)class_9135.field_48556.decode((Object)registryFriendlyByteBuf), ((Float)class_9135.field_48552.decode((Object)registryFriendlyByteBuf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)registryFriendlyByteBuf)).floatValue(), (Long)class_9135.field_48551.decode((Object)registryFriendlyByteBuf), (class_7225.class_7874)registryFriendlyByteBuf.method_56349());
        }

        public void encode(class_9129 o, HamsterWheelSoldierData hamsterWheelSoldierData) {
            STREAM_CODEC_ENTITY_TYPE.encode((Object)o, hamsterWheelSoldierData.type);
            class_2960.field_48267.encode((Object)o, (Object)hamsterWheelSoldierData.getTeamId());
            class_9135.field_48552.encode((Object)o, (Object)Float.valueOf(hamsterWheelSoldierData.soldierScale));
            class_9135.field_48552.encode((Object)o, (Object)Float.valueOf(hamsterWheelSoldierData.speed));
            class_9135.field_48551.encode((Object)o, (Object)hamsterWheelSoldierData.enterTime);
        }
    };
    public static final String CLIENT_TAG = "client";
    private static final String ENTITY_TYPE_TAG = "type";
    private static final String DATA_TAG = "SoldierData";
    private static final String SOLDIER_SIZE_TAG = "SoldierSize";
    private static final String SOLDIER_SPEED_TAG = "SoldierSpeed";
    private static final String SOLDIER_ENTER_TAG = "SoldierEnterTime";
    private final class_1299<? extends AbstractClaySoldierEntity> type;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_2487 data;
    @NotNull
    private final class_6880.class_6883<ClayMobTeam> teamReference;
    private final float soldierScale;
    private final float speed;
    private final float roundedSpeed;
    private final long enterTime;
    @Nullable
    private ClientClaySoldierEntity clientSoldier;

    private HamsterWheelSoldierData(class_1299<? extends AbstractClaySoldierEntity> type, class_2487 data, class_2960 teamId, float soldierScale, float speed, long enterTime, class_7225.class_7874 registries) {
        this.type = type;
        this.data = data;
        this.speed = speed;
        this.roundedSpeed = (float)Math.round((double)speed * 3.4 * 10.0) / 10.0f;
        this.soldierScale = soldierScale;
        this.enterTime = enterTime;
        this.teamReference = ClayMobTeamManger.getHolder(teamId, registries).orElse(ClayMobTeamManger.getDefault(registries));
    }

    public class_2960 getTeamId() {
        return this.teamReference.method_40237().method_29177();
    }

    private static HamsterWheelSoldierData createUnsafe(class_1299<?> type, class_2960 id, class_2487 tag, float size, float speed, long enterTime, class_7225.class_7874 registries) {
        try {
            return new HamsterWheelSoldierData(type, tag, id, size, speed, enterTime, registries);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Type " + String.valueOf(type) + " does not extend AbstractClaySoldierEntity");
        }
    }

    public static HamsterWheelSoldierData of(AbstractClaySoldierEntity soldier) {
        class_2487 compoundtag = new class_2487();
        soldier.method_5662(compoundtag);
        IGNORED_TAGS.forEach(arg_0 -> ((class_2487)compoundtag).method_10551(arg_0));
        return HamsterWheelSoldierData.createUnsafe(soldier.method_5864(), soldier.getClayTeamType(), compoundtag, soldier.method_55693(), (float)soldier.method_5996(class_5134.field_23719).method_6194(), soldier.method_37908().method_8510(), (class_7225.class_7874)soldier.method_56673());
    }

    public void save(class_2487 tag) {
        ENTITY_TYPE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.type).ifSuccess(typeTag -> tag.method_10566(ENTITY_TYPE_TAG, typeTag)).ifError(err -> LOGGER.error(err.message()));
        ClayMobTeam.save(this.getTeamId(), tag);
        if (tag.method_10545(CLIENT_TAG)) {
            tag.method_10566(DATA_TAG, (class_2520)this.getForClient());
        } else {
            tag.method_10566(DATA_TAG, (class_2520)this.getForServer());
            tag.method_10544(SOLDIER_ENTER_TAG, this.enterTime);
        }
        if (this.soldierScale != 1.0f) {
            tag.method_10548(SOLDIER_SIZE_TAG, this.soldierScale);
        }
        if (this.speed >= 0.31f || this.speed <= 0.29f) {
            tag.method_10548(SOLDIER_SPEED_TAG, this.speed);
        }
    }

    @Nullable
    public static HamsterWheelSoldierData load(class_2487 tag, class_2338 pos, class_8080 state, class_7225.class_7874 registries) {
        if (!tag.method_10545(ENTITY_TYPE_TAG)) {
            return null;
        }
        class_1299 type = (class_1299)ENTITY_TYPE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(ENTITY_TYPE_TAG)).getOrThrow(err -> new IllegalStateException("Cannot load SoldierBlockData without EntityType: " + err));
        class_2960 id = ClayMobTeam.read(tag);
        class_2487 data = tag.method_10562(DATA_TAG);
        float size = 1.0f;
        if (tag.method_10573(SOLDIER_SIZE_TAG, 99)) {
            size = tag.method_10583(SOLDIER_SIZE_TAG);
        }
        float speed = 0.3f;
        if (tag.method_10573(SOLDIER_SPEED_TAG, 99)) {
            speed = tag.method_10583(SOLDIER_SPEED_TAG);
        }
        HamsterWheelSoldierData blockData = HamsterWheelSoldierData.createUnsafe(type, id, data, size, speed, tag.method_10537(SOLDIER_ENTER_TAG), registries);
        if (tag.method_10545(CLIENT_TAG)) {
            blockData.setUpClient(pos, state);
        }
        return blockData;
    }

    public static void markTagAsClient(class_2487 tag) {
        tag.method_10556(CLIENT_TAG, true);
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAdjustedSpeed() {
        return this.roundedSpeed;
    }

    public AbstractClaySoldierEntity createSoldier(class_1937 level) {
        class_2487 newEntityData = this.data.method_10553();
        IGNORED_TAGS.forEach(arg_0 -> ((class_2487)newEntityData).method_10551(arg_0));
        AbstractClaySoldierEntity entity = (AbstractClaySoldierEntity)this.type.method_5883(level);
        ClayMobTeam.save(this.getTeamId(), newEntityData);
        if (entity != null) {
            class_9279.method_57456((class_2487)newEntityData).method_57445((class_1297)entity);
            if (this.data.method_25928("UUID")) {
                entity.method_5826(this.data.method_25926("UUID"));
            } else {
                ErrorHandler.INSTANCE.debug("Loaded a ClaySoldier without its UUID");
            }
            entity.method_6088().clear();
            entity.method_6088().putAll(HamsterWheelSoldierData.loadEffects(this.data, (int)(level.method_8510() - this.enterTime)));
            return entity;
        }
        return null;
    }

    private static Map<class_6880<class_1291>, class_1293> loadEffects(class_2487 tag, int elapsedTime) {
        HashMap<class_6880<class_1291>, class_1293> map = new HashMap<class_6880<class_1291>, class_1293>();
        if (tag.method_10573(ACTIVE_EFFECTS_TAG, 9)) {
            class_2499 listtag = tag.method_10554(ACTIVE_EFFECTS_TAG, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                class_2487 compoundtag = listtag.method_10602(i);
                class_1293 oldEff = class_1293.method_5583((class_2487)compoundtag);
                if (oldEff == null || oldEff.method_48557(elapsedTime)) continue;
                class_1293 newInstance = new class_1293(oldEff.method_5579(), Math.max(1, oldEff.method_5584() - elapsedTime), oldEff.method_5578(), oldEff.method_5591(), oldEff.method_5581(), oldEff.method_5592());
                map.put((class_6880<class_1291>)oldEff.method_5579(), newInstance);
            }
        }
        return map;
    }

    @Nullable
    public ClientClaySoldierEntity getClientSoldier() {
        return this.clientSoldier;
    }

    private class_2487 getForClient() {
        class_2487 tag = new class_2487();
        ArrayList missingTags = new ArrayList();
        CLIENT_NEEDED_TAGS.forEach(tagKey -> {
            class_2520 entry = this.data.method_10580(tagKey);
            if (entry != null) {
                tag.method_10566(tagKey, entry);
            } else {
                missingTags.add(tagKey);
            }
        });
        if (!missingTags.isEmpty()) {
            LOGGER.debug("Missing Client Tags: {}", missingTags);
        }
        ClayMobTeam.save(this.getTeamId(), tag);
        return tag;
    }

    private class_2487 getForServer() {
        class_2487 tag = this.data.method_10553();
        ClayMobTeam.save(this.getTeamId(), tag);
        return tag;
    }

    private void setUpClient(class_2338 pos, class_8080 state) {
        this.clientSoldier = ClientClaySoldierEntity.create(this.type, this.data, pos, state, this.teamReference, this.soldierScale);
        this.clientSoldier.setUpCape();
    }

    public void dropItems(class_3218 level, double x, double y, double z) {
        ArrayList stackWithEffects = new ArrayList();
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierHandItems", (i, s) -> stackWithEffects.add(s), level.method_30349());
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierArmorItems", (i, s) -> stackWithEffects.add(s), level.method_30349());
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierBackpackItems", (i, s) -> stackWithEffects.add(s), level.method_30349());
        AbstractClaySoldierEntity.dropInventory(level, slot -> (ItemStackWithEffect)stackWithEffects.get(slot.ordinal()), (slot, stack) -> HamsterWheelSoldierData.spawnItemInWorld(level, stack, x, y, z));
        if (this.data.method_10545("DropSpawnedFrom") && this.data.method_10577("DropSpawnedFrom")) {
            ClayMobEntity.dropSpawnedFrom(level, ClayMobEntity.getSpawnedFromFromTag(this.data, level.method_30349()), stack -> HamsterWheelSoldierData.spawnItemInWorld(level, stack, x, y, z), false, false);
        }
    }

    private static void spawnItemInWorld(class_3218 level, class_1799 stack, double x, double y, double z) {
        class_1542 itemEntity = new class_1542((class_1937)level, x, y, z, stack);
        itemEntity.method_6988();
        level.method_8649((class_1297)itemEntity);
    }

    public String toString() {
        return "HamsterWheelSoldierData(%s(%s))".formatted(this.type.method_31794().getSimpleName(), this.getTeamId());
    }
}

