/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class BlueprintData {
    private static final String BLUEPRINT_DATA_TAG = "BlueprintData";
    public static final Codec<BlueprintData> JSON_CODEC = RecordCodecBuilder.create(in -> in.group((App)class_2960.field_25139.fieldOf("location").forGetter(BlueprintData::location), (App)Codec.STRING.fieldOf("name").forGetter(BlueprintData::name), (App)Codec.FLOAT.optionalFieldOf("marking", (Object)Float.valueOf(0.0f)).forGetter(BlueprintData::marking)).apply((Applicative)in, BlueprintData::new));
    private final class_2960 location;
    private final String name;
    private final float marking;
    private BaseImmutableTemplate template;
    @Nullable
    private class_265 voxelShape;
    private boolean valid = false;

    public BlueprintData(class_2960 location, String name, float marking) {
        this.location = location;
        this.name = name;
        this.marking = marking;
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)this.name());
    }

    public void save(class_2487 tag, class_7225.class_7874 registries) {
        registries.method_46762(ModRegistries.BLUEPRINTS).method_42017().filter(h -> ((BlueprintData)h.comp_349()).equals(this)).findAny().ifPresentOrElse(holder -> class_2960.field_25139.encodeStart((DynamicOps)class_2509.field_11560, (Object)holder.method_40237().method_29177()).ifSuccess(key -> tag.method_10566(BLUEPRINT_DATA_TAG, key)).ifError(err -> ClaySoldiersCommon.LOGGER.error("Error Saving Key of {} to tag: {}", (Object)holder.method_40237(), (Object)err.message())), () -> ClaySoldiersCommon.LOGGER.error("Error Loading Blueprint Data from Tag"));
    }

    public void bindStructure(BaseImmutableTemplate template) {
        if (template == null) {
            return;
        }
        this.template = template;
        this.voxelShape = template.getShape();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Optional<ServerBlueprintPlan> createServerPlan() {
        return this.valid ? this.template.createServer() : Optional.empty();
    }

    public Optional<BlueprintPlan> createClientPlan() {
        return this.valid ? this.template.createClient() : Optional.empty();
    }

    @Nullable
    public static BlueprintData load(class_2487 tag, class_7225.class_7874 pRegistries) {
        if (!tag.method_10545(BLUEPRINT_DATA_TAG)) {
            return null;
        }
        class_2960 key = (class_2960)class_2960.field_25139.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(BLUEPRINT_DATA_TAG)).getOrThrow();
        Optional holder = pRegistries.method_46762(ModRegistries.BLUEPRINTS).method_46746(class_5321.method_29179(ModRegistries.BLUEPRINTS, (class_2960)key));
        if (holder.isEmpty()) {
            ClaySoldiersCommon.LOGGER.error("Tried Loading Blueprint Data that does not exist {}", (Object)key);
        }
        return holder.map(class_6880.class_6883::comp_349).orElse(null);
    }

    public class_2960 location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    public float marking() {
        return this.marking;
    }

    public BaseImmutableTemplate getTemplate() {
        if (!this.valid) {
            throw new IllegalStateException("Tried getting the Template, but data is invalid " + String.valueOf(this));
        }
        return this.template;
    }

    public class_265 getShape() {
        if (!this.valid) {
            throw new IllegalStateException("Tried getting the Shape, but data is invalid " + String.valueOf(this));
        }
        return this.voxelShape;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlueprintData that = (BlueprintData)obj;
        return Objects.equals(this.location, that.location) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.name);
    }

    public String toString() {
        return "BlueprintData[%s, %s, %s, %s, %s]".formatted(this.name, this.location.method_12832(), this.valid ? "Valid" : "Invalid", this.template == null ? "NoTemplate" : this.template.toShortString(), this.voxelShape == null ? "NoShape" : "WithShape");
    }
}

