/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintItem;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class BlueprintManger
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String BLUEPRINT_FILE_PATH = "%s/blueprint".formatted("csr");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_7225<class_2248> blockLookup;
    private final class_7225<BlueprintData> blueprintHolders;
    private final BiConsumer<BlueprintManger, class_3300> tagLoader;

    public BlueprintManger(class_7225<class_2248> blockLookup, class_7225<BlueprintData> blueprintRegistry, BiConsumer<BlueprintManger, class_3300> tagLoader) {
        super(GSON, BLUEPRINT_FILE_PATH);
        this.blockLookup = blockLookup;
        this.blueprintHolders = blueprintRegistry;
        this.tagLoader = tagLoader;
    }

    protected void apply(Map<class_2960, JsonElement> jsonElementMap, class_3300 pResourceManager, class_3695 pProfiler) {
        this.tagLoader.accept(this, pResourceManager);
        LOGGER.info("Clay Soldiers: Done Loading {} Blueprints", this.blueprintHolders.method_42017().map(class_6880::comp_349).toList());
    }

    public void onTagLoad(class_3300 pResourceManager, Collection<class_6880<class_2248>> blackListedBlocks) {
        Function<class_2960, Optional<ImmutableTemplate>> helper = BlueprintUtil.createBlueprintLoader(pResourceManager, this.blockLookup, blackListedBlocks);
        this.blueprintHolders.method_42017().map(class_6880.class_6883::comp_349).forEach(data -> ((Optional)helper.apply(data.location())).ifPresentOrElse(data::bindStructure, () -> LOGGER.error("Clay Soldiers: Couldn't load structure {} for Blueprint", (Object)data.location())));
    }

    public static List<class_1799> getBlueprintItems(class_7225.class_7874 provider) {
        return provider.method_46762(ModRegistries.BLUEPRINTS).method_42017().filter(h -> ((BlueprintData)h.comp_349()).isValid()).map(BlueprintItem::createStackFromData).toList();
    }

    public static class_1799 createBlueprintItem(BlueprintData data, class_5455 registryAccess) {
        return BlueprintItem.createStackFromData((class_6880<BlueprintData>)registryAccess.method_30530(ModRegistries.BLUEPRINTS).method_47983((Object)data));
    }

    @ApiStatus.Internal
    public static void setupClient(Map<class_2960, BaseImmutableTemplate> blueprintShapes, class_5455 access) {
        class_2378 reg = access.method_30530(ModRegistries.BLUEPRINTS);
        reg.method_40270().forEach(holder -> ((BlueprintData)holder.comp_349()).bindStructure((BaseImmutableTemplate)blueprintShapes.get(holder.method_40237().method_29177())));
        reg.method_40270().forEach(data -> {
            if (!((BlueprintData)data.comp_349()).isValid()) {
                LOGGER.error("Clay Soldiers: Loaded Invalid Blueprint Data on the Client {}", data);
            }
        });
        LOGGER.info("Clay Soldiers: Done Loading {} Blueprints on Client", reg.method_10220().toList());
    }

    @ApiStatus.Internal
    public static Map<class_2960, BaseImmutableTemplate> getBlueprintShapeData(class_5455 registryAccess) {
        HashMap<class_2960, BaseImmutableTemplate> map = new HashMap<class_2960, BaseImmutableTemplate>();
        registryAccess.method_30530(ModRegistries.BLUEPRINTS).method_40270().filter(h -> ((BlueprintData)h.comp_349()).isValid()).forEach(h -> map.put(h.method_40237().method_29177(), ((BlueprintData)h.comp_349()).getTemplate()));
        return map;
    }
}

