/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ClientBlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.UnmodifiableView;

public class BaseImmutableTemplate {
    private static final class_9139<ByteBuf, class_238> AABB_STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48553, aabb -> aabb.field_1323, (class_9139)class_9135.field_48553, aabb -> aabb.field_1322, (class_9139)class_9135.field_48553, aabb -> aabb.field_1321, (class_9139)class_9135.field_48553, aabb -> aabb.field_1320, (class_9139)class_9135.field_48553, aabb -> aabb.field_1325, (class_9139)class_9135.field_48553, aabb -> aabb.field_1324, class_238::new);
    private static final class_9139<ByteBuf, class_265> VOXEL_SHAPE_STREAM_CODEC = AABB_STREAM_CODEC.method_56433(class_9135.method_56363()).method_56432(aabbs -> aabbs.stream().map(class_259::method_1078).reduce(class_259.method_1073(), (voxelShape, voxelShape2) -> class_259.method_1082((class_265)voxelShape, (class_265)voxelShape2, (class_247)class_247.field_1366)).method_1097(), class_265::method_1090);
    public static final class_9139<class_9129, BaseImmutableTemplate> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), (class_9139)class_9135.field_48550), BaseImmutableTemplate::getItemCountMap, (class_9139)class_2338.field_48404.method_56432(b -> b, class_2338::new), BaseImmutableTemplate::getSize, VOXEL_SHAPE_STREAM_CODEC, BaseImmutableTemplate::getShape, BaseImmutableTemplate::new);
    protected final class_2382 size;
    private final Map<class_1792, Integer> itemCountMap;
    private final List<class_1799> neededItems;
    private final class_265 shape;
    private final int totalNeededItems;

    public BaseImmutableTemplate(Map<class_1792, Integer> itemCountMap, class_2382 size, class_265 shape) {
        this.size = size;
        this.itemCountMap = ImmutableMap.copyOf(itemCountMap);
        this.shape = shape;
        this.neededItems = BlueprintUtil.itemMapToList(itemCountMap);
        this.totalNeededItems = itemCountMap.values().stream().reduce(0, Integer::sum);
    }

    public List<class_1799> getNeededItems() {
        return this.neededItems;
    }

    private @UnmodifiableView Map<class_1792, Integer> getItemCountMap() {
        return this.itemCountMap;
    }

    protected int totalNeededItems() {
        return this.totalNeededItems;
    }

    public class_2382 getSize() {
        return this.size;
    }

    public String toString() {
        return "BaseImmutableTemplate{%s Items(%s): %s}".formatted(this.size, this.totalNeededItems, this.itemCountMap);
    }

    public String toShortString() {
        return "BaseImmutableTemplate{%s Items(%s)}".formatted(this.size, this.totalNeededItems);
    }

    public class_265 getShape() {
        return this.shape;
    }

    public Optional<ServerBlueprintPlan> createServer() {
        return Optional.empty();
    }

    public Optional<BlueprintPlan> createClient() {
        return Optional.of(new ClientBlueprintPlan(new HashMap<class_1792, Integer>(this.itemCountMap), this.size));
    }
}

