/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class BlueprintBlockInfo {
    private static final int MIN_ATTEMPT_TIME = 24000;
    private final class_2338 pos;
    private final class_2680 state;
    @Nullable
    private final class_2487 nbt;
    @Nullable
    private BlueprintRequest lastRequest;

    public BlueprintBlockInfo(class_2338 pos, class_2680 state, @Nullable class_2487 nbt) {
        this.pos = pos;
        this.state = state;
        this.nbt = nbt;
    }

    public static BlueprintBlockInfo fromInfo(class_3499.class_3501 info) {
        return new BlueprintBlockInfo(info.comp_1341(), info.comp_1342(), info.comp_1343() != null ? info.comp_1343().method_10553() : null);
    }

    public boolean isFor(class_2248 block) {
        return this.state.method_27852(block);
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    public boolean hasAvailableRequest(long gameTime) {
        return this.lastRequest == null || this.lastRequest.isCancelled() || this.lastRequest.getStart() + 24000L < gameTime;
    }

    public BlueprintRequest getRequest(long gameTime, class_2338 destinationPos) {
        BlueprintRequest req = new BlueprintRequest(this.state.method_26204().method_8389(), destinationPos, gameTime);
        if (this.lastRequest != null) {
            this.lastRequest.cancel();
        }
        this.lastRequest = req;
        return req;
    }

    public void markDone() {
        if (this.lastRequest != null) {
            this.lastRequest.setFinished();
        }
    }

    public String toString() {
        return "BlockInfo{%s, %s, [%s]}".formatted(this.pos, this.state, this.lastRequest);
    }
}

