/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7923;

public abstract class BlueprintPlan {
    public static final String ITEMS_TAG = "ItemMap";
    public static final String HAS_STARTED_TAG = "Started";
    protected static final Codec<Map<class_1792, Integer>> ITEM_COUNT_MAP_CODEC = Codec.unboundedMap((Codec)class_7923.field_41178.method_39673(), (Codec)Codec.INT);
    private boolean hasStarted;
    private final Map<class_1792, Integer> itemCountMap;
    private final class_2382 size;

    public BlueprintPlan(Map<class_1792, Integer> itemCountMap, class_2382 size) {
        this.itemCountMap = itemCountMap;
        this.size = size;
        this.hasStarted = false;
    }

    public abstract PlaceResult tryPlacing(class_1937 var1, class_1799 var2, class_2338 var3, BlueprintTemplateSettings var4);

    public boolean hasItemAndShrink(class_1792 item) {
        if (!this.itemCountMap.containsKey(item)) {
            return false;
        }
        Integer count = this.itemCountMap.get(item);
        if (count == null || count <= 0) {
            return false;
        }
        Integer n = count;
        count = count - 1;
        if (count <= 0) {
            this.itemCountMap.remove(item);
        } else {
            this.itemCountMap.put(item, count);
        }
        return true;
    }

    protected int getNumberOfItems() {
        return this.itemCountMap.values().stream().reduce(0, Integer::sum);
    }

    public List<class_1799> getNeededItems() {
        return BlueprintUtil.itemMapToList(this.itemCountMap);
    }

    public boolean isFinished() {
        return this.itemCountMap.isEmpty();
    }

    public class_2382 getSize() {
        return this.size;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public void saveHasStarted(class_2487 tag) {
        if (this.hasStarted()) {
            tag.method_10556(HAS_STARTED_TAG, true);
        }
    }

    public void saveSize(class_2487 tag) {
        tag.method_10566("size", (class_2520)this.newIntegerList(this.getSize().method_10263(), this.getSize().method_10264(), this.getSize().method_10260()));
    }

    public void saveItems(class_2487 tag) {
        if (this.itemCountMap.isEmpty()) {
            return;
        }
        ITEM_COUNT_MAP_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.itemCountMap).ifSuccess(itemCountTag -> tag.method_10566(ITEMS_TAG, itemCountTag)).ifError(tagError -> ClaySoldiersCommon.LOGGER.error(tagError.message()));
    }

    protected void loadItemCount(class_2487 tag) {
        if (tag.method_10545(ITEMS_TAG)) {
            ITEM_COUNT_MAP_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(ITEMS_TAG)).ifSuccess(this.itemCountMap::putAll).ifError(mapError -> BlueprintUtil.LOGGER.error(mapError.message()));
        }
    }

    protected void loadHasStarted(class_2487 tag) {
        this.hasStarted = tag.method_10545(HAS_STARTED_TAG) && tag.method_10577(HAS_STARTED_TAG);
    }

    protected class_2499 newIntegerList(int ... pValues) {
        class_2499 listtag = new class_2499();
        for (int i : pValues) {
            listtag.add((Object)class_2497.method_23247((int)i));
        }
        return listtag;
    }

    public static enum PlaceResult {
        SUCCESS,
        NOT_NEEDED,
        CANT_PLACE;


        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public boolean isFail() {
            return this != SUCCESS;
        }
    }
}

