/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6826;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class BlueprintUtil {
    public static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final class_7654 RESOURCE_LISTER = new class_7654("structure", ".nbt");

    public static List<class_1799> itemMapToList(Map<class_1792, Integer> itemMap) {
        ArrayList<class_1799> itemsSorted = new ArrayList<class_1799>(itemMap.size());
        itemMap.forEach((item, count) -> BlueprintUtil.addItemStackToList(itemsSorted, item, count));
        return itemsSorted;
    }

    public static void addItemStackToList(List<class_1799> itemsCounted, class_1792 item, int count) {
        int maxStackSize = item.method_7882();
        if (count <= maxStackSize) {
            itemsCounted.add(new class_1799((class_1935)item, count));
        } else {
            itemsCounted.add(new class_1799((class_1935)item, maxStackSize));
            BlueprintUtil.addItemStackToList(itemsCounted, item, count - maxStackSize);
        }
    }

    public static class_2382 getSizeFromTag(class_2487 tag) {
        if (!tag.method_10545("size")) {
            return class_2382.field_11176;
        }
        class_2499 sizeVec = tag.method_10554("size", 3);
        return new class_2382(sizeVec.method_10600(0), sizeVec.method_10600(1), sizeVec.method_10600(2));
    }

    public static <T> Map<class_1792, Integer> getNeededItemsFromInfo(List<T> blockInfoList, Function<T, class_2680> stateGetter) {
        HashMap<class_1792, Integer> map = new HashMap<class_1792, Integer>();
        blockInfoList.stream().map(stateGetter).map(state -> state.method_26204().method_8389()).filter(item -> item != class_1802.field_8162).forEach(item -> {
            Integer count = (Integer)map.get(item);
            if (count == null) {
                map.put((class_1792)item, 1);
            } else {
                count = count + 1;
                map.put((class_1792)item, count);
            }
        });
        return map;
    }

    public static Function<class_2960, Optional<ImmutableTemplate>> createBlueprintLoader(class_3300 resourceManager, class_7225<class_2248> blockLookup, Collection<class_6880<class_2248>> blackListedBlocks) {
        return new BlueprintLoader(resourceManager, blockLookup, blackListedBlocks)::loadFromResource;
    }

    private record BlueprintLoader(class_3300 resourceManager, class_7225<class_2248> blockLookup, Collection<class_6880<class_2248>> blackListedBlocks) {
        public Optional<ImmutableTemplate> loadFromResource(class_2960 location) {
            class_2960 resourcelocation = RESOURCE_LISTER.method_45112(location);
            return this.load(() -> this.resourceManager.open(resourcelocation), error -> LOGGER.error("CSR: Couldn't load structure {}", (Object)location, error));
        }

        private Optional<ImmutableTemplate> load(InputStreamOpener pInputStream, Consumer<Throwable> pOnError) {
            try {
                Optional<ImmutableTemplate> optional;
                try (InputStream inputstream = pInputStream.open();
                     class_6826 inputstream1 = new class_6826(inputstream);){
                    optional = Optional.of(this.readStructure((InputStream)inputstream1));
                }
                return optional;
            }
            catch (FileNotFoundException filenotfoundexception) {
                return Optional.empty();
            }
            catch (Throwable throwable1) {
                pOnError.accept(throwable1);
                return Optional.empty();
            }
        }

        private ImmutableTemplate readStructure(InputStream pStream) throws IOException {
            return ImmutableTemplate.create(this.blockLookup, class_2507.method_10629((InputStream)pStream, (class_2505)class_2505.method_53898()), this.blackListedBlocks);
        }
    }

    public static class SimplePalette
    implements Iterable<class_2680> {
        public static final class_2680 DEFAULT_BLOCK_STATE = class_2246.field_10124.method_9564();
        private final class_2361<class_2680> ids = new class_2361(16);
        private int lastId;

        public int idFor(class_2680 pState) {
            int i = this.ids.method_10206((Object)pState);
            if (i == -1) {
                i = this.lastId++;
                this.ids.method_10203((Object)pState, i);
            }
            return i;
        }

        @Nullable
        public class_2680 stateFor(int pId) {
            class_2680 blockstate = (class_2680)this.ids.method_10200(pId);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<class_2680> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(class_2680 pState, int pId) {
            this.ids.method_10203((Object)pState, pId);
        }
    }

    @FunctionalInterface
    private static interface InputStreamOpener {
        public InputStream open() throws IOException;
    }
}

