/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_3726;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ImmutableTemplate
extends BaseImmutableTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<class_3499.class_3501> blockInfoList;

    protected ImmutableTemplate(List<class_3499.class_3501> blockInfoList, Map<class_1792, Integer> itemCountMap, class_2382 size, class_265 shape) {
        super(itemCountMap, size, shape);
        this.blockInfoList = blockInfoList;
    }

    @Override
    public String toString() {
        return "ImmutableTemplate{%s Blocks(%s): %s}".formatted(this.size, this.blockInfoList.size(), this.blockInfoList);
    }

    @Override
    public String toShortString() {
        return "ImmutableTemplate{%s Items(%s) Blocks(%s)}".formatted(this.size, this.totalNeededItems(), this.blockInfoList.size());
    }

    @Override
    public Optional<ServerBlueprintPlan> createServer() {
        return Optional.of(new ServerBlueprintPlan(this.size, this.blockInfoList));
    }

    @Override
    public Optional<BlueprintPlan> createClient() {
        return Optional.empty();
    }

    public static ImmutableTemplate create(class_7225<class_2248> pBlockGetter, class_2487 pTag, Collection<class_6880<class_2248>> blackListedBlocks) {
        List<class_3499.class_3501> blockInfoList;
        class_2499 blockListTag = pTag.method_10554("blocks", 10);
        if (pTag.method_10573("palettes", 9)) {
            class_2499 palettesListTag = pTag.method_10554("palettes", 9);
            blockInfoList = ImmutableTemplate.loadPallet(pBlockGetter, palettesListTag.method_10603(0), blockListTag, blackListedBlocks);
            LOGGER.warn("Clay Soldiers: Structure containing more than one Pallet. Using the first one");
        } else {
            blockInfoList = ImmutableTemplate.loadPallet(pBlockGetter, pTag.method_10554("palette", 10), blockListTag, blackListedBlocks);
        }
        return new ImmutableTemplate(blockInfoList, BlueprintUtil.getNeededItemsFromInfo(blockInfoList, class_3499.class_3501::comp_1342), BlueprintUtil.getSizeFromTag(pTag), ImmutableTemplate.buildShape(blockInfoList));
    }

    public static List<class_3499.class_3501> loadPallet(class_7225<class_2248> pBlockGetter, class_2499 pPaletteTag, class_2499 pBlocksTag, Collection<class_6880<class_2248>> blackListedBlocks) {
        BlueprintUtil.SimplePalette structuretemplate$simplepalette = new BlueprintUtil.SimplePalette();
        for (int i = 0; i < pPaletteTag.size(); ++i) {
            structuretemplate$simplepalette.addMapping(class_2512.method_10681(pBlockGetter, (class_2487)pPaletteTag.method_10602(i)), i);
        }
        ArrayList normalBlocks = Lists.newArrayList();
        ArrayList blockWithNbt = Lists.newArrayList();
        ArrayList blockWithSpecialShape = Lists.newArrayList();
        for (int j = 0; j < pBlocksTag.size(); ++j) {
            class_2487 compoundtag = pBlocksTag.method_10602(j);
            class_2499 listtag = compoundtag.method_10554("pos", 3);
            class_2338 blockpos = new class_2338(listtag.method_10600(0), listtag.method_10600(1), listtag.method_10600(2));
            class_2680 blockState = structuretemplate$simplepalette.stateFor(compoundtag.method_10550("state"));
            class_2487 nbt = null;
            if (compoundtag.method_10545("nbt") && (nbt = compoundtag.method_10562("nbt")).method_10545("final_state")) {
                String finalState = nbt.method_10558("final_state");
                try {
                    blockState = class_2259.method_41957(pBlockGetter, (String)finalState, (boolean)true).comp_622();
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Error while parsing BlockState {} in Blueprint, has an invalid final state of {}. ", (Object)blockState, (Object)finalState);
                }
                nbt.method_10551("final_state");
                if (nbt.method_33133()) {
                    nbt = null;
                }
            }
            if (blockState == null) {
                LOGGER.error("Error while parsing BlockState in Blueprint");
                continue;
            }
            class_3499.class_3501 blockInfo = new class_3499.class_3501(blockpos, blockState, nbt);
            ImmutableTemplate.addToLists(blockInfo, normalBlocks, blockWithNbt, blockWithSpecialShape, pBlockGetter, blackListedBlocks);
        }
        return ImmutableTemplate.buildInfoList(normalBlocks, blockWithNbt, blockWithSpecialShape);
    }

    private static void addToLists(class_3499.class_3501 blockInfo, List<class_3499.class_3501> pNormalBlocks, List<class_3499.class_3501> pBlocksWithNbt, List<class_3499.class_3501> pBlocksWithSpecialShape, class_7225<class_2248> lookup, Collection<class_6880<class_2248>> blackListedBlocks) {
        class_3499.class_3501 updatedBlockInfo = ImmutableTemplate.updateBlockInfo(blockInfo, lookup);
        if (updatedBlockInfo == null) {
            return;
        }
        if (blackListedBlocks.stream().anyMatch(blockHolder -> updatedBlockInfo.comp_1342().method_53257(blockHolder))) {
            return;
        }
        if (updatedBlockInfo.comp_1343() != null) {
            pBlocksWithNbt.add(updatedBlockInfo);
        } else if (!updatedBlockInfo.comp_1342().method_26204().method_9543() && updatedBlockInfo.comp_1342().method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) {
            pNormalBlocks.add(updatedBlockInfo);
        } else {
            pBlocksWithSpecialShape.add(updatedBlockInfo);
        }
    }

    @Nullable
    private static class_3499.class_3501 updateBlockInfo(class_3499.class_3501 info, class_7225<class_2248> pBlockGetter) {
        return ImmutableTemplate.filterIllegalStates(ImmutableTemplate.setFinalState(info, pBlockGetter));
    }

    private static class_3499.class_3501 setFinalState(class_3499.class_3501 info, class_7225<class_2248> pBlockGetter) {
        if (info.comp_1343() == null) {
            return info;
        }
        String finalState = info.comp_1343().method_10558("final_state");
        if (finalState.isEmpty()) {
            return info;
        }
        try {
            return new class_3499.class_3501(info.comp_1341(), class_2259.method_41957(pBlockGetter, (String)finalState, (boolean)true).comp_622(), info.comp_1343());
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            LOGGER.error("Error while parsing blockstate {} in for original block {}", (Object)finalState, (Object)info.comp_1342());
            return info;
        }
    }

    private static class_265 buildShape(List<class_3499.class_3501> list) {
        return list.stream().map(ImmutableTemplate::shapeFromBlockInfo).reduce(class_259.method_1073(), (voxelShape1, voxelShape2) -> class_259.method_1082((class_265)voxelShape1, (class_265)voxelShape2, (class_247)class_247.field_1366)).method_1097();
    }

    private static class_265 shapeFromBlockInfo(class_3499.class_3501 blockInfo) {
        class_2680 state = blockInfo.comp_1342();
        class_265 shape = ImmutableTemplate.getShapeFromState(state, blockInfo.comp_1341()).method_1096((double)blockInfo.comp_1341().method_10263(), (double)blockInfo.comp_1341().method_10264(), (double)blockInfo.comp_1341().method_10260());
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            state.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
            class_265 shapeUpper = ImmutableTemplate.getShapeFromState(state, blockInfo.comp_1341()).method_1096((double)blockInfo.comp_1341().method_10263(), (double)(blockInfo.comp_1341().method_10264() + 1), (double)blockInfo.comp_1341().method_10260());
            state.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
            return class_259.method_1082((class_265)shape, (class_265)shapeUpper, (class_247)class_247.field_1366);
        }
        if (state.method_28498((class_2769)class_2741.field_12483)) {
            state.method_11657((class_2769)class_2741.field_12483, (Comparable)class_2742.field_12560);
            class_2338 posBedHead = blockInfo.comp_1341().method_10093((class_2350)state.method_11654((class_2769)class_2741.field_12481));
            class_265 shapeHead = ImmutableTemplate.getShapeFromState(state, blockInfo.comp_1341()).method_1096((double)posBedHead.method_10263(), (double)posBedHead.method_10264(), (double)posBedHead.method_10260());
            state.method_11657((class_2769)class_2741.field_12483, (Comparable)class_2742.field_12557);
            return class_259.method_1082((class_265)shape, (class_265)shapeHead, (class_247)class_247.field_1366);
        }
        return shape;
    }

    private static class_265 getShapeFromState(class_2680 state, class_2338 pos) {
        return state.method_26194((class_1922)class_2682.field_12294, pos, class_3726.method_16194()).method_52620();
    }

    @Nullable
    private static class_3499.class_3501 filterIllegalStates(class_3499.class_3501 info) {
        class_2680 state = info.comp_1342();
        if (ImmutableTemplate.isIllegalSate(state, class_2741.field_12533, class_2756.field_12609)) {
            return null;
        }
        if (ImmutableTemplate.isIllegalSate(state, class_2741.field_12483, class_2742.field_12560)) {
            return null;
        }
        return info;
    }

    private static <T extends Comparable<T>> boolean isIllegalSate(class_2680 state, class_2769<T> property, T when) {
        return when.equals(state.method_28500(property).orElse(null));
    }

    private static List<class_3499.class_3501> buildInfoList(List<class_3499.class_3501> pNormalBlocks, List<class_3499.class_3501> pBlocksWithNbt, List<class_3499.class_3501> pBlocksWithSpecialShape) {
        Comparator<class_3499.class_3501> comparator = Comparator.comparingInt(p_74641_ -> p_74641_.comp_1341().method_10264()).thenComparingInt(p_74637_ -> p_74637_.comp_1341().method_10263()).thenComparingInt(p_74572_ -> p_74572_.comp_1341().method_10260());
        pNormalBlocks.sort(comparator);
        pBlocksWithSpecialShape.sort(comparator);
        pBlocksWithNbt.sort(comparator);
        ArrayList<class_3499.class_3501> list = new ArrayList<class_3499.class_3501>();
        list.addAll(pNormalBlocks);
        list.addAll(pBlocksWithSpecialShape);
        list.addAll(pBlocksWithNbt);
        list = list.stream().filter(blockInfo -> !blockInfo.comp_1342().method_26215()).toList();
        return list;
    }
}

