/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintBlockInfo;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ServerBlueprintPlan
extends BlueprintPlan {
    private final List<BlueprintBlockInfo> blockInfoList;

    public ServerBlueprintPlan(class_2382 size, List<class_3499.class_3501> blockInfoList) {
        super(BlueprintUtil.getNeededItemsFromInfo(blockInfoList, class_3499.class_3501::comp_1342), size);
        this.blockInfoList = ServerBlueprintPlan.fromBlockInfoList(blockInfoList);
    }

    public static ServerBlueprintPlan load(class_2487 tag, class_7225.class_7874 registries) {
        ServerBlueprintPlan serverBlueprintPlan = new ServerBlueprintPlan(BlueprintUtil.getSizeFromTag(tag), ImmutableTemplate.loadPallet((class_7225<class_2248>)registries.method_46762(class_7924.field_41254), tag.method_10554("palette", 10), tag.method_10554("blocks", 10), List.of()));
        serverBlueprintPlan.loadHasStarted(tag);
        return serverBlueprintPlan;
    }

    public class_2487 save(class_2487 pTag) {
        if (this.blockInfoList.isEmpty()) {
            pTag.method_10566("blocks", (class_2520)new class_2499());
            pTag.method_10566("palette", (class_2520)new class_2499());
        } else {
            BlueprintUtil.SimplePalette simplePalette = new BlueprintUtil.SimplePalette();
            class_2499 blockInfoAsPallet = new class_2499();
            this.blockInfoList.forEach(blockInfo -> {
                class_2487 compoundtag = new class_2487();
                compoundtag.method_10566("pos", (class_2520)this.newIntegerList(blockInfo.getPos().method_10263(), blockInfo.getPos().method_10264(), blockInfo.getPos().method_10260()));
                int stateId = simplePalette.idFor(blockInfo.getState());
                compoundtag.method_10569("state", stateId);
                if (blockInfo.getNbt() != null) {
                    compoundtag.method_10566("nbt", (class_2520)blockInfo.getNbt());
                }
                blockInfoAsPallet.add((Object)compoundtag);
            });
            pTag.method_10566("blocks", (class_2520)blockInfoAsPallet);
            class_2499 palletTag = new class_2499();
            for (class_2680 blockstate : simplePalette) {
                palletTag.add((Object)class_2512.method_10686((class_2680)blockstate));
            }
            pTag.method_10566("palette", (class_2520)palletTag);
        }
        this.saveSize(pTag);
        this.saveHasStarted(pTag);
        return pTag;
    }

    @Override
    public BlueprintPlan.PlaceResult tryPlacing(class_1937 level, class_1799 itemStack, class_2338 base, BlueprintTemplateSettings settings) {
        BlueprintPlan.PlaceResult res = this.tryPlacingAll(((class_1747)itemStack.method_7909()).method_7711(), itemStack, level, base, settings);
        if (res == BlueprintPlan.PlaceResult.SUCCESS && !this.hasItemAndShrink(itemStack.method_7909())) {
            throw new IllegalStateException("Successfully placed a Block which was not needed");
        }
        return res;
    }

    private BlueprintPlan.PlaceResult tryPlacingAll(class_2248 block, class_1799 stack, class_1937 level, class_2338 base, BlueprintTemplateSettings settings) {
        Iterator<BlueprintBlockInfo> iterator = this.blockInfoList.iterator();
        while (iterator.hasNext()) {
            class_3499.class_3501 updatedBlockInfo;
            BlueprintBlockInfo blockInfo = iterator.next();
            if (!blockInfo.isFor(block) || !this.placeBlock(stack, level, (updatedBlockInfo = ServerBlueprintPlan.processBlockInfos(settings, blockInfo)).comp_1341().method_10081((class_2382)base), updatedBlockInfo.comp_1342().method_26185(settings.mirror()).method_26186(settings.rotation()))) continue;
            iterator.remove();
            blockInfo.markDone();
            return BlueprintPlan.PlaceResult.SUCCESS;
        }
        return BlueprintPlan.PlaceResult.CANT_PLACE;
    }

    private boolean placeBlock(class_1799 stack, class_1937 level, class_2338 pos, class_2680 state) {
        if (!this.canPlaceBlock(level, pos)) {
            return false;
        }
        if (level.method_8652(pos, state, 3)) {
            state.method_26204().method_9567(level, pos, state, null, stack);
            return true;
        }
        return false;
    }

    private boolean canPlaceBlock(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26215() || state.method_45474();
    }

    private static class_3499.class_3501 processBlockInfos(BlueprintTemplateSettings pSettings, BlueprintBlockInfo pBlockInfo) {
        return new class_3499.class_3501(ServerBlueprintPlan.adjustForStructureSettings(pSettings, pBlockInfo.getPos()), pBlockInfo.getState(), pBlockInfo.getNbt() != null ? pBlockInfo.getNbt().method_10553() : null);
    }

    public String toString() {
        return "ServerBlueprintTemplate{%s Blocks(%s) Items(%s): %s}".formatted(this.getSize(), this.blockInfoList.size(), this.getNumberOfItems(), this.getNeededItems());
    }

    @Nullable
    public BlueprintRequest getRequest(class_3218 level, class_2338 base, BlueprintTemplateSettings settings, Predicate<class_2338> canReach) {
        Supplier<BlueprintRequest> fallbackRequest = null;
        for (BlueprintBlockInfo blockInfo : this.blockInfoList) {
            class_2338 infoAbsolutePos = base.method_10081((class_2382)ServerBlueprintPlan.adjustForStructureSettings(settings, blockInfo.getPos()));
            if (!canReach.test(infoAbsolutePos) || !this.canPlaceBlock((class_1937)level, infoAbsolutePos)) continue;
            if (blockInfo.hasAvailableRequest(level.method_8510())) {
                return blockInfo.getRequest(level.method_8510(), infoAbsolutePos);
            }
            if (fallbackRequest != null) continue;
            fallbackRequest = () -> blockInfo.getRequest(level.method_8510(), infoAbsolutePos);
        }
        return fallbackRequest != null ? (BlueprintRequest)fallbackRequest.get() : null;
    }

    @Override
    public boolean isFinished() {
        return this.blockInfoList.isEmpty();
    }

    private static class_2338 adjustForStructureSettings(BlueprintTemplateSettings settings, class_2338 pos) {
        return class_3499.method_15171((class_3492)settings.convertTo(), (class_2338)pos.method_10081((class_2382)class_2338.field_10980));
    }

    private static List<BlueprintBlockInfo> fromBlockInfoList(List<class_3499.class_3501> infoList) {
        return infoList.stream().map(BlueprintBlockInfo::fromInfo).collect(Collectors.toCollection(LinkedList::new));
    }
}

