/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import java.util.Iterator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricBlockStorageCache
implements IBlockCache<IBlockStorageAccess> {
    private final BlockApiCache<Storage<ItemVariant>, @Nullable class_2350> cache;

    public FabricBlockStorageCache(class_3218 level, class_2338 pos) {
        this.cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)level, (class_2338)pos);
    }

    @Override
    public class_2338 pos() {
        return this.cache.getPos();
    }

    @Override
    @Nullable
    public IBlockStorageAccess getCapability() {
        Storage views = (Storage)this.cache.find(null);
        if (views == null) {
            return null;
        }
        return new FabricBlockStorageAccess((Storage<ItemVariant>)views);
    }

    public record FabricBlockStorageAccess(@NotNull Storage<ItemVariant> storage) implements IBlockStorageAccess
    {
        @Override
        public class_1799 tryInserting(class_1799 stack) {
            ItemVariant itemVariant = ItemVariant.of((class_1799)stack);
            int maxCount = stack.method_7947();
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = this.storage.insert((Object)itemVariant, (long)maxCount, (TransactionContext)transaction);
                transaction.commit();
                int remaining = (int)((long)maxCount - inserted);
                if (remaining <= 0) {
                    class_1799 class_17992 = class_1799.field_8037;
                    return class_17992;
                }
                class_1799 class_17993 = stack.method_46651(remaining);
                return class_17993;
            }
        }

        @Override
        public class_1799 tryExtracting(Predicate<class_1799> stackPredicate, int amountToExtract) {
            StorageView view;
            ItemVariant itemVariant = null;
            Iterator iterator = this.storage.nonEmptyViews().iterator();
            while (iterator.hasNext() && !stackPredicate.test((itemVariant = (ItemVariant)(view = (StorageView)iterator.next()).getResource()).toStack())) {
                itemVariant = null;
            }
            if (itemVariant == null) {
                return class_1799.field_8037;
            }
            try (Transaction transaction = Transaction.openOuter();){
                int amount = (int)this.storage.extract((Object)itemVariant, (long)amountToExtract, (TransactionContext)transaction);
                if (amount > 0) {
                    transaction.commit();
                    class_1799 class_17992 = itemVariant.toStack(amount);
                    return class_17992;
                }
            }
            return class_1799.field_8037;
        }

        @Override
        public void forEach(ToIntFunction<class_1799> test, Consumer<class_1799> thenDo, BooleanSupplier finished) {
            for (StorageView view : this.storage.nonEmptyViews()) {
                if (finished.getAsBoolean()) break;
                ItemVariant itemVariant = (ItemVariant)view.getResource();
                int amountWanted = test.applyAsInt(itemVariant.toStack());
                if (amountWanted <= 0) continue;
                Transaction transaction = Transaction.openOuter();
                try {
                    int amount = (int)this.storage.extract((Object)itemVariant, (long)amountWanted, (TransactionContext)transaction);
                    if (amount <= 0) continue;
                    transaction.commit();
                    thenDo.accept(itemVariant.toStack(amount));
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
        }
    }
}

