/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import net.bumblebee.claysoldiers.ClaySoldierFabric;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class FabricEnergyStorage
extends SimpleEnergyStorage
implements IHamsterWheelEnergyStorage {
    private final HamsterWheelBlockEntity blockEntity;
    private final FabricViewOnly viewOnly;
    @Nullable
    private BlockApiCache<EnergyStorage, class_2350> cached;

    public FabricEnergyStorage(HamsterWheelBlockEntity hamsterWheelBlockEntity) {
        super(0L, 0L, ClaySoldierFabric.hamsterWheelCapacity);
        this.blockEntity = hamsterWheelBlockEntity;
        this.viewOnly = new FabricViewOnly(this);
    }

    public long getCapacity() {
        return ClaySoldierFabric.hamsterWheelCapacity * (long)this.blockEntity.getEnergyCapacityMultiplier();
    }

    @Override
    public void setEnergy(long energy) {
        this.amount = energy;
    }

    public boolean supportsExtraction() {
        return super.supportsExtraction() && this.blockEntity.hasEnergyStorage();
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return this.blockEntity.hasEnergyStorage() ? super.extract(maxAmount, transaction) : 0L;
    }

    @Override
    public long energyStored() {
        return this.getAmount();
    }

    @Override
    public long maxEnergyStored() {
        return this.getCapacity();
    }

    @Override
    public void generate(float speed) {
        EnergyStorage storage;
        long generated = this.amount + (long)((int)Math.max(1.0f, (float)ClaySoldierFabric.hamsterWheelSpeed * speed));
        if (generated < 0L) {
            generated = Long.MAX_VALUE;
        }
        this.amount = Math.min(generated, this.getCapacity());
        class_1937 class_19372 = this.blockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2350 direction = (class_2350)this.blockEntity.method_11010().method_11654((class_2769)HamsterWheelBlock.FACING);
        if (this.cached == null) {
            this.cached = BlockApiCache.create((BlockApiLookup)EnergyStorage.SIDED, (class_3218)serverLevel, (class_2338)this.blockEntity.method_11016().method_10093(direction));
        }
        if ((storage = (EnergyStorage)this.cached.find((Object)direction.method_10153())) != null && storage.supportsInsertion()) {
            try (Transaction transaction = Transaction.openOuter();){
                long insertable;
                try (Transaction simulateTransaction = transaction.openNested();){
                    insertable = storage.insert(Long.MAX_VALUE, (TransactionContext)simulateTransaction);
                }
                long extracted = this.extract(insertable, (TransactionContext)transaction);
                long inserted = storage.insert(extracted, (TransactionContext)transaction);
                if (extracted == inserted) {
                    transaction.commit();
                }
            }
        }
    }

    @Override
    public void save(class_2487 tag) {
        tag.method_10544("wheel_energy", this.amount);
    }

    @Override
    public void load(class_2487 tag) {
        this.amount = Math.min(ClaySoldierFabric.hamsterWheelCapacity, tag.method_10537("wheel_energy"));
    }

    @Override
    public IHamsterWheelEnergyStorage asViewOnly() {
        return this.viewOnly;
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
        this.blockEntity.method_5431();
    }

    private record FabricViewOnly(FabricEnergyStorage storage) implements IHamsterWheelEnergyStorage,
    EnergyStorage
    {
        public boolean supportsExtraction() {
            return false;
        }

        @Override
        public long energyStored() {
            return this.storage.energyStored();
        }

        @Override
        public long maxEnergyStored() {
            return this.storage.maxEnergyStored();
        }

        @Override
        public void generate(float speed) {
        }

        @Override
        public void save(class_2487 tag) {
        }

        @Override
        public void load(class_2487 tag) {
        }

        @Override
        public void setEnergy(long energy) {
            this.storage.setEnergy(energy);
        }

        @Override
        public IHamsterWheelEnergyStorage asViewOnly() {
            return this;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            return this.storage.getAmount();
        }

        public long getCapacity() {
            return this.storage.getCapacity();
        }
    }
}

