/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claypoifunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunction;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunctionSerializer;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claypoifunction.ClaySoldierInventorySetter;
import net.bumblebee.claysoldiers.claypoifunction.ColorGetterFunction;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AdditionalSoldierData;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class ClayPoiFunctions {
    private static final Supplier<ClayPoiFunctionSerializer<EffectFunction>> EFFECT_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("apply_effect", () -> new ClayPoiFunctionSerializer<EffectFunction>(EffectFunction.CODEC.fieldOf("effect"), EffectFunction.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<SetItem>> SET_ITEM_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("set_item", () -> new ClayPoiFunctionSerializer<SetItem>(SetItem.CODEC.fieldOf("set_item"), SetItem.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<ConvertTo>> CONVERSION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("conversion", () -> new ClayPoiFunctionSerializer<ConvertTo>(ConvertTo.CODEC.fieldOf("conversion"), ConvertTo.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<DyeSoldierFunction>> DYE_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("dye_soldier", () -> new ClayPoiFunctionSerializer<DyeSoldierFunction>(DyeSoldierFunction.CODEC.fieldOf("dye"), DyeSoldierFunction.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<SelectRandom>> SELECT_RANDOM_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("select_random", () -> new ClayPoiFunctionSerializer<SelectRandom>(SelectRandom.CODEC.fieldOf("selection"), SelectRandom.STREAM_CODEC));
    private static final String COMPONENT_PREFIX = "clay_poi_function.csr.";
    public static final String EFFECT_FUNCTION_ADD = "clay_poi_function.csr.effect_function_add";
    public static final String EFFECT_FUNCTION_REMOVE = "clay_poi_function.csr.effect_function_remove";
    public static final String EFFECT_FUNCTION_INCREASE = "clay_poi_function.csr.effect_function_increase";
    public static final String DYE_FUNCTION = "clay_poi_function.csr.dye_function";
    public static final String SET_ITEM_FUNCTION = "clay_poi_function.csr.set_item_function";
    public static final String SET_ITEM_FIND_FUNCTION = "clay_poi_function.csr.set_item_function_find";
    public static final String CONVERSION_FUNCTION = "clay_poi_function.csr.conversion";
    public static final String SELECT_RANDOM_FUNCTION = "clay_poi_function.csr.select_random";

    private ClayPoiFunctions() {
    }

    public static void init() {
    }

    public static class SelectRandom
    extends ClayPoiFunction<SelectRandom> {
        private static final class_9139<class_9129, Map<ClayPoiFunction<?>, Float>> MAP_STREAM_CODEC = class_9135.method_56377(HashMap::new, ClayPoiFunction.STREAM_CODEC, (class_9139)class_9135.field_48552);
        private static final Codec<SelectRandom> CODEC = ClayPoiFunction.CODEC.listOf().xmap(SelectRandom::new, s -> s.chanceList);
        private static final class_9139<class_9129, SelectRandom> STREAM_CODEC = class_9139.method_56434(ClayPoiFunction.LIST_STREAM_CODEC, s -> s.chanceList, SelectRandom::new);
        private final List<ClayPoiFunction<?>> chanceList;

        private SelectRandom(List<ClayPoiFunction<?>> functions) {
            super(SELECT_RANDOM_FUNCTION_SERIALIZER);
            this.chanceList = functions;
            if (this.chanceList.isEmpty()) {
                throw new IllegalStateException("Chance List cannot be empty");
            }
        }

        private void forEach(Consumer<ClayPoiFunction<?>> apply) {
            this.chanceList.forEach(apply);
        }

        public static SelectRandom allEqual(ClayPoiFunction<?> ... functions) {
            return new SelectRandom(List.of(functions));
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            ((ClayPoiFunction)class_156.method_32309(this.chanceList, (class_5819)soldier.getClaySoldierRandom())).accept(soldier, source);
        }

        @Override
        @Nullable
        public List<class_2561> getDisplayNameDynamic(class_1657 player) {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)ClayPoiFunctions.SELECT_RANDOM_FUNCTION));
            this.forEach(func -> func.getDisplayNameDynamic(player).forEach((? super T component) -> list.add((class_2561)class_5244.method_48320().method_10852(component))));
            return list;
        }
    }

    public static class DyeSoldierFunction
    extends ClayPoiFunction<DyeSoldierFunction> {
        public static final Codec<DyeSoldierFunction> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.either(ColorHelper.CODEC, ColorGetterFunction.CODEC).fieldOf("color").forGetter(DyeSoldierFunction::getEither), (App)Codec.BOOL.optionalFieldOf("overwrite", (Object)false).forGetter(d -> d.overwrite)).apply((Applicative)in, DyeSoldierFunction::new));
        public static final class_9139<class_9129, DyeSoldierFunction> STREAM_CODEC = class_9139.method_56436(ColorHelper.STREAM_CODEC, s -> s.color, ColorGetterFunction.STREAM_CODEC, s -> s.colorGetter, (class_9139)class_9135.field_48547, s -> s.overwrite, DyeSoldierFunction::new);
        private final ColorHelper color;
        private final ColorGetterFunction colorGetter;
        private final boolean overwrite;

        private DyeSoldierFunction(ColorHelper color, ColorGetterFunction colorGetter, boolean overwrite) {
            super(DYE_FUNCTION_SERIALIZER);
            this.color = color;
            this.colorGetter = colorGetter;
            this.overwrite = overwrite;
        }

        private DyeSoldierFunction(Either<ColorHelper, ColorGetterFunction> either, boolean overwrite) {
            super(DYE_FUNCTION_SERIALIZER);
            this.overwrite = overwrite;
            if (either.left().isPresent()) {
                this.color = (ColorHelper)either.left().get();
                this.colorGetter = ColorGetterFunction.NONE;
            } else {
                this.colorGetter = (ColorGetterFunction)either.right().orElseThrow();
                this.color = ColorHelper.EMPTY;
            }
        }

        public DyeSoldierFunction(ColorGetterFunction colorGetter, boolean overwrite) {
            this(ColorHelper.EMPTY, colorGetter, overwrite);
        }

        public DyeSoldierFunction(int color, boolean overwrite) {
            this(ColorHelper.color(color), ColorGetterFunction.NONE, overwrite);
        }

        public DyeSoldierFunction(ColorHelper color, boolean overwrite) {
            this(color, ColorGetterFunction.NONE, overwrite);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            ColorHelper currentColor = ColorHelper.color(this.colorGetter.getColor(source));
            if (currentColor.isEmpty()) {
                currentColor = this.color;
            }
            if (this.overwrite) {
                soldier.setOffsetColor(currentColor);
            } else {
                soldier.addOffsetColor(currentColor);
            }
        }

        private Either<ColorHelper, ColorGetterFunction> getEither() {
            if (this.colorGetter != ColorGetterFunction.NONE) {
                return Either.right((Object)this.colorGetter);
            }
            return Either.left((Object)this.color);
        }

        @Override
        @Nullable
        public List<class_2561> getDisplayNameDynamic(class_1657 player) {
            if (this.colorGetter != ColorGetterFunction.NONE) {
                return List.of(class_2561.method_43469((String)ClayPoiFunctions.DYE_FUNCTION, (Object[])new Object[]{this.colorGetter.getAnimatedDisplayName((class_1309)player)}));
            }
            return List.of(class_2561.method_43469((String)ClayPoiFunctions.DYE_FUNCTION, (Object[])new Object[]{this.color.formatDynamic((class_1309)player)}));
        }
    }

    public static class ConvertTo
    extends ClayPoiFunction<ConvertTo> {
        private static final Codec<ConvertTo> CODEC = AdditionalSoldierData.CODEC.xmap(d -> new ConvertTo(d.soldierType(), d.tag()), c -> c.data);
        private static final class_9139<class_9129, ConvertTo> STREAM_CODEC = AdditionalSoldierData.STREAM_CODEC.method_56432(d -> new ConvertTo(d.soldierType(), d.tag()), c -> c.data);
        private final AdditionalSoldierData data;

        public <T extends ClayMobEntity> ConvertTo(class_1299<T> soldier, class_2487 tag) {
            super(CONVERSION_SERIALIZER);
            this.data = new AdditionalSoldierData(soldier, tag);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            if (soldier instanceof AbstractClaySoldierEntity) {
                AbstractClaySoldierEntity entity = (AbstractClaySoldierEntity)soldier;
                this.data.convert(entity);
            }
        }

        @Override
        public class_2561 getDisplayName() {
            return class_2561.method_43469((String)ClayPoiFunctions.CONVERSION_FUNCTION, (Object[])new Object[]{this.data.soldierType().method_5897()});
        }

        @Override
        public String toString() {
            return "%s(%s)".formatted(super.toString(), this.data);
        }
    }

    public static class SetItem
    extends ClayPoiFunction<SetItem> {
        public static final Codec<SetItem> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_1799.field_49266.fieldOf("item").forGetter(s -> s.item), (App)SoldierEquipmentSlot.CODEC.optionalFieldOf("slot").forGetter(SetItem::getSlot), (App)SetItemOperation.CODEC.optionalFieldOf("operation", (Object)SetItemOperation.DROP).forGetter(s -> s.operation)).apply((Applicative)in, (item, slot, setItemOperation) -> new SetItem((class_1799)item, slot.orElse(null), (SetItemOperation)((Object)((Object)setItemOperation)))));
        public static final class_9139<class_9129, SetItem> STREAM_CODEC = class_9139.method_56436((class_9139)class_1799.field_49268, s -> s.item, SoldierEquipmentSlot.OPTIONAL_STREAM_CODEC, s -> Optional.ofNullable(s.slot), SetItemOperation.STREAM_CODEC, s -> s.operation, (stack, slot, op) -> new SetItem((class_1799)stack, slot.orElse(null), (SetItemOperation)((Object)op)));
        private final class_1799 item;
        @Nullable
        private final SoldierEquipmentSlot slot;
        private final SetItemOperation operation;

        private SetItem(class_1799 item, @Nullable SoldierEquipmentSlot slot, SetItemOperation operation) {
            super(SET_ITEM_FUNCTION_SERIALIZER);
            this.item = item;
            this.slot = slot;
            this.operation = operation;
        }

        private Optional<SoldierEquipmentSlot> getSlot() {
            return Optional.ofNullable(this.slot);
        }

        public static SetItem replace(class_1799 item, @Nullable SoldierEquipmentSlot slot) {
            return new SetItem(item, slot, SetItemOperation.REPLACE);
        }

        public static SetItem drop(class_1799 item, @Nullable SoldierEquipmentSlot slot) {
            return new SetItem(item, slot, SetItemOperation.DROP);
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            if (this.slot == null) {
                return class_2561.method_43469((String)ClayPoiFunctions.SET_ITEM_FIND_FUNCTION, (Object[])new Object[]{this.item.method_7954()});
            }
            return class_2561.method_43469((String)ClayPoiFunctions.SET_ITEM_FUNCTION, (Object[])new Object[]{this.item.method_7954(), this.slot.getDisplayName()});
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource ignored) {
            if (this.slot == null) {
                SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(this.item);
                if (effect == null) {
                    ClaySoldiersCommon.LOGGER.error("Set Item in suitable Slot is only supported for items that can be held by soldiers. {} cannot be held.", (Object)this.item.method_7909());
                    return;
                }
                for (SoldierEquipmentSlot possibleSlot : effect.slots()) {
                    if (!soldier.setSlotIfEmpty(possibleSlot, this.item)) continue;
                    if (this.operation == SetItemOperation.DROP) {
                        soldier.dropItemSlotWithChance(possibleSlot);
                    }
                    return;
                }
                return;
            }
            if (this.operation == SetItemOperation.DROP) {
                soldier.dropItemSlotWithChance(this.slot);
            }
            soldier.setItemSlot(this.slot, this.item);
        }
    }

    public static class EffectFunction
    extends ClayPoiFunction<EffectFunction>
    implements EffectHolder {
        public static final Codec<EffectFunction> CODEC = RecordCodecBuilder.create(in -> in.group((App)EffectOperation.CODEC.fieldOf("operation").forGetter(ef -> ef.operation)).and(CodecUtils.addEffectAnd()).apply((Applicative)in, EffectFunction::new));
        public static final class_9139<class_9129, EffectFunction> STREAM_CODEC = class_9139.method_56905(EffectOperation.STREAM_CODEC, t -> t.operation, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), t -> t.effect, (class_9139)class_9135.field_48550, t -> t.duration, (class_9139)class_9135.field_48550, t -> t.amplifier, EffectFunction::new);
        private final EffectOperation operation;
        private final class_6880<class_1291> effect;
        private final int duration;
        private final int amplifier;

        private EffectFunction(EffectOperation operation, class_6880<class_1291> effect, int duration, int amplifier) {
            super(EFFECT_FUNCTION_SERIALIZER);
            this.operation = operation;
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        public static EffectFunction addEffect(class_6880<class_1291> effect, int duration, int amplifier) {
            return new EffectFunction(EffectOperation.ADD, effect, duration, amplifier);
        }

        public static EffectFunction removeEffect(class_6880<class_1291> effect) {
            return new EffectFunction(EffectOperation.REMOVE, effect, 0, 0);
        }

        public static EffectFunction increaseEffect(class_6880<class_1291> effect, int duration, int amplifier) {
            return new EffectFunction(EffectOperation.INCREASE, effect, duration, amplifier);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource ignored) {
            this.operation.accept(soldier, new class_1293(this.effect, this.duration, this.amplifier, false, false));
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public class_6880<class_1291> effectHolder() {
            return this.effect;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return switch (this.operation.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_2561.method_43469((String)ClayPoiFunctions.EFFECT_FUNCTION_ADD, (Object[])new Object[]{((class_1291)this.effect.comp_349()).method_5560(), this.amplifier + 1, this.durationToString()});
                case 2 -> class_2561.method_43469((String)ClayPoiFunctions.EFFECT_FUNCTION_REMOVE, (Object[])new Object[]{((class_1291)this.effect.comp_349()).method_5560()});
                case 1 -> class_2561.method_43469((String)ClayPoiFunctions.EFFECT_FUNCTION_INCREASE, (Object[])new Object[]{((class_1291)this.effect.comp_349()).method_5560(), this.amplifier, this.durationToString()});
            };
        }

        private class_2561 durationToString() {
            if (this.duration == -1 || this.duration > 9999) {
                return class_2561.method_43470((String)"forever");
            }
            return class_2561.method_43470((String)(this.duration / 20 + "s"));
        }
    }

    private static enum SetItemOperation implements class_3542
    {
        REPLACE("replace"),
        DROP("drop");

        private static final Codec<SetItemOperation> CODEC;
        private static final class_9139<class_2540, SetItemOperation> STREAM_CODEC;
        private final String serializedName;

        private SetItemOperation(String serializedName) {
            this.serializedName = serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(SetItemOperation::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(SetItemOperation.class);
        }
    }

    private static enum EffectOperation implements class_3542
    {
        ADD("add", (soldier, effect) -> soldier.addMobEffect((class_1293)effect, null)),
        INCREASE("increase", (soldier, effect) -> soldier.increaseEffect((class_1293)effect, null)),
        REMOVE("remove", (soldier, effect) -> soldier.removeMobEffect((class_6880<class_1291>)effect.method_5579()));

        public static final Codec<EffectOperation> CODEC;
        public static final class_9139<class_2540, EffectOperation> STREAM_CODEC;
        private final String serializedNamed;
        private final BiConsumer<ClaySoldierInventorySetter, class_1293> consumer;

        private EffectOperation(String serializedNamed, BiConsumer<ClaySoldierInventorySetter, class_1293> consumer) {
            this.serializedNamed = serializedNamed;
            this.consumer = consumer;
        }

        public void accept(ClaySoldierInventorySetter soldier, class_1293 effect) {
            this.consumer.accept(soldier, effect);
        }

        public String method_15434() {
            return this.serializedNamed;
        }

        static {
            CODEC = class_3542.method_28140(EffectOperation::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(EffectOperation.class);
        }
    }
}

