/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_9139;

public class OnUseCondition
extends RemovalCondition {
    public static final Codec<OnUseCondition> MELEE_CODEC = OnUseCondition.createForType(RemovalConditionContext.Type.MELEE_ATTACK);
    public static final Codec<OnUseCondition> RANGED_CODEC = OnUseCondition.createForType(RemovalConditionContext.Type.RANGED_ATTACK);
    public static final class_9139<ByteBuf, OnUseCondition> MELEE_STREAM_CODEC = OnUseCondition.createChacneStreamCodec(OnUseCondition::melee);
    public static final class_9139<ByteBuf, OnUseCondition> RANGED_STREAM_CODEC = OnUseCondition.createChacneStreamCodec(OnUseCondition::ranged);
    public static final String MELEE_LANG_KEY = "clay_removal_condition.csr..on_use.melee";
    public static final String RANGED_LANG_KEY = "clay_removal_condition.csr..on_use.ranged";
    public static final String ERROR_LANG_KEY = "clay_removal_condition.csr..on_use.error";

    public static OnUseCondition melee(float chance) {
        return new OnUseCondition(RemovalConditionContext.Type.MELEE_ATTACK, chance);
    }

    public static OnUseCondition ranged(float chance) {
        return new OnUseCondition(RemovalConditionContext.Type.RANGED_ATTACK, chance);
    }

    private OnUseCondition(RemovalConditionContext.Type type, float chance) {
        super(chance, type);
    }

    @Override
    public boolean shouldRemove(AbstractClaySoldierEntity soldier, RemovalConditionContext context) {
        return this.baseTest(context.getType(), soldier.method_59922());
    }

    @Override
    public class_2561 getDisplayName() {
        return switch (this.getType()) {
            case RemovalConditionContext.Type.RANGED_ATTACK -> class_2561.method_43471((String)RANGED_LANG_KEY);
            case RemovalConditionContext.Type.MELEE_ATTACK -> class_2561.method_43471((String)MELEE_LANG_KEY);
            default -> class_2561.method_43469((String)ERROR_LANG_KEY, (Object[])new Object[]{this.getType().method_15434()}).method_27692(class_124.field_1061);
        };
    }

    private static Codec<OnUseCondition> createForType(RemovalConditionContext.Type type) {
        return CHANCE_CODEC.xmap(chance -> new OnUseCondition(type, chance.floatValue()), RemovalCondition::getChance);
    }
}

