/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3542;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class RemovalConditionContext {
    private final Type type;
    private final class_1799 stack;
    @Nullable
    private final class_1282 sources;
    @Nullable
    private final MovementType movementType;

    public Type getType() {
        return this.type;
    }

    public class_1799 stack() {
        return this.stack;
    }

    @Nullable
    public class_1282 getDamageSource() {
        return this.sources;
    }

    @Nullable
    public MovementType getMovementType() {
        return this.movementType;
    }

    public static RemovalConditionContext useMelee(class_1799 stack) {
        return new RemovalConditionContext(Type.MELEE_ATTACK, stack, null, null);
    }

    public static RemovalConditionContext useRanged(class_1799 stack) {
        return new RemovalConditionContext(Type.RANGED_ATTACK, stack, null, null);
    }

    public static RemovalConditionContext hurt(class_1282 sources, class_1799 stack) {
        return new RemovalConditionContext(Type.HURT, stack, sources, null);
    }

    public static RemovalConditionContext teleportation(class_1799 stack, MovementType movementType) {
        return new RemovalConditionContext(Type.TELEPORT, stack, null, movementType);
    }

    public static RemovalConditionContext fireworkRocket(class_1799 stack) {
        return new RemovalConditionContext(Type.FLIGHT, stack, null, MovementType.TO_SAFETY);
    }

    public static RemovalConditionContext bounce(class_1799 stack) {
        return new RemovalConditionContext(Type.BOUNCE, stack, null, null);
    }

    public RemovalConditionContext(Type type, class_1799 stack, @Nullable class_1282 sources, @Nullable MovementType movementType) {
        this.type = type;
        this.stack = stack;
        this.sources = sources;
        this.movementType = movementType;
    }

    public static enum Type implements class_3542
    {
        RANGED_ATTACK("ranged"),
        MELEE_ATTACK("melee"),
        TELEPORT("teleport"),
        FLIGHT("flight"),
        HURT("hurt"),
        BOUNCE("bounce");

        private final String serializedName;

        private Type(String serializedName) {
            this.serializedName = serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }
    }

    public static enum MovementType implements class_3542,
    KeyableTranslatableProperty
    {
        TO_OWNER("to_owner"),
        TO_TARGET("to_target"),
        TO_SAFETY("to_safety");

        public static final Codec<MovementType> CODEC;
        public static final class_9139<class_2540, MovementType> STREAM_CODEC;
        private static final String LANG_PREFIX = "clay_removal_condition.csr.context.";
        private final String serializedName;

        private MovementType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        @Override
        public String translatableKey() {
            return LANG_PREFIX + this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(MovementType::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(MovementType.class);
        }
    }
}

