/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claysoldierpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicate;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicatePriority;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicateSerializer;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClayPredicates {
    public static final Supplier<ClayPredicateSerializer<ItemPredicate>> ITEM_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_item", () -> new ClayPredicateSerializer<ItemPredicate>(ItemPredicate.CODEC, ItemPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<LogicPredicate>> LOGIC_PREDICATE_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("logic", () -> new ClayPredicateSerializer<LogicPredicate>(LogicPredicate.CODEC, LogicPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<SoldierPropertyPredicate>> SOLDIER_HOLDABLE_PROPERTY_PREDICATE = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("holdable_property", () -> new ClayPredicateSerializer<SoldierPropertyPredicate>(SoldierPropertyPredicate.CODEC, SoldierPropertyPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<EffectPredicate>> EFFECT_PREDICATE = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_effect", () -> new ClayPredicateSerializer<EffectPredicate>(EffectPredicate.CODEC, EffectPredicate.STREAM_CODEC));
    private static final String COMPONENT_PREFIX = "clay_soldier_predicate.csr.";
    public static final String ITEM_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.item_predicate";
    public static final String ITEM_PREDICATE_ANY_COMPONENT = "clay_soldier_predicate.csr.item_predicate_any";
    public static final String SOLDIER_PROPERTY_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.soldier_property_predicate";
    public static final String EFFECT_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.effect_predicate";
    public static final String EFFECT_PREDICATE_DURATION_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.duration";
    public static final String EFFECT_PREDICATE_AMPLIFIER_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.amplifier";
    public static final String EFFECT_PREDICATE_DURATION_AMPLIFIER_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.duration_amplifier";
    public static final String HAS_CUSTOM_COLOR_COMPONENT = "clay_soldier_predicate.csr.custom_color_predicate";
    public static final Supplier<ClayPredicateSerializer<ConstantPredicate>> ALWAYS_TRUE_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("always_true", () -> new ClayPredicateSerializer<ConstantPredicate>(ConstantPredicate.ALWAYS_TRUE_CODEC));
    public static final Supplier<ClayPredicateSerializer<ConstantPredicate>> HAS_CUSTOM_COLOR_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_custom_color", () -> new ClayPredicateSerializer<ConstantPredicate>(ConstantPredicate.HAS_CUSTOM_COLOR_CODEC));

    private ClayPredicates() {
    }

    public static void init() {
    }

    public static class ConstantPredicate
    extends ClayPredicate<ConstantPredicate> {
        private static final Codec<ConstantPredicate> ALWAYS_TRUE_CODEC = Codec.unit(ConstantPredicate::getAlwaysTruePredicate);
        private static final Codec<ConstantPredicate> HAS_CUSTOM_COLOR_CODEC = Codec.unit(ConstantPredicate::getHasCustomColor);
        private static ConstantPredicate ALWAYS_TRUE_INSTANCE = null;
        private static ConstantPredicate CUSTOM_COLOR_INSTANCE = null;
        private final Predicate<ClaySoldierInventoryQuery> value;
        @Nullable
        private final String translatableKey;

        public static ConstantPredicate getAlwaysTruePredicate() {
            if (ALWAYS_TRUE_INSTANCE == null) {
                ALWAYS_TRUE_INSTANCE = new ConstantPredicate(ALWAYS_TRUE_SERIALIZER, s -> true, null);
            }
            return ALWAYS_TRUE_INSTANCE;
        }

        public static ConstantPredicate getHasCustomColor() {
            if (CUSTOM_COLOR_INSTANCE == null) {
                CUSTOM_COLOR_INSTANCE = new ConstantPredicate(HAS_CUSTOM_COLOR_SERIALIZER, ClaySoldierInventoryQuery::hasOffsetColor, ClayPredicates.HAS_CUSTOM_COLOR_COMPONENT);
            }
            return CUSTOM_COLOR_INSTANCE;
        }

        private ConstantPredicate(Supplier<ClayPredicateSerializer<ConstantPredicate>> serializer, Predicate<ClaySoldierInventoryQuery> value, @Nullable String displayName) {
            super(serializer);
            this.value = value;
            this.translatableKey = displayName;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return this.translatableKey == null ? null : class_2561.method_43471((String)this.translatableKey);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            return this.value.test(soldier);
        }

        public String toString() {
            return "ConstantPredicate: " + (this.translatableKey == null ? "AlwaysTrue" : "Custom Color");
        }
    }

    public static class EffectPredicate
    extends ClayPredicate<EffectPredicate>
    implements EffectHolder {
        public static final Codec<EffectPredicate> CODEC = EffectHolder.getCodec(EffectPredicate::fromEffectHolder, "min");
        private static final class_9139<class_9129, EffectPredicate> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), EffectPredicate::effectHolder, (class_9139)class_9135.field_48550, EffectPredicate::duration, (class_9139)class_9135.field_48550, EffectPredicate::amplifier, EffectPredicate::new);
        private final class_6880<class_1291> effect;
        private final int minDuration;
        private final int minAmplifier;

        public EffectPredicate(class_6880<class_1291> effect, int minDuration, int minAmplifier) {
            super(EFFECT_PREDICATE);
            this.effect = effect;
            this.minDuration = minDuration;
            this.minAmplifier = minAmplifier;
        }

        public EffectPredicate(class_6880<class_1291> effect) {
            this(effect, 0, 0);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            class_1293 mobEffect = soldier.getMobEffect(this.effect);
            return mobEffect != null && mobEffect.method_5578() >= this.minAmplifier && mobEffect.method_5584() >= this.minDuration;
        }

        @Override
        public class_1291 effect() {
            return (class_1291)this.effect.comp_349();
        }

        @Override
        public int duration() {
            return this.minDuration;
        }

        @Override
        public int amplifier() {
            return this.minAmplifier;
        }

        @Override
        public class_6880<class_1291> effectHolder() {
            return this.effect;
        }

        private static EffectPredicate fromEffectHolder(EffectHolder effectHolder) {
            return new EffectPredicate(effectHolder.effectHolder(), effectHolder.amplifier(), effectHolder.duration());
        }

        @Override
        public class_2561 getDisplayName() {
            if (this.minDuration > 0 && this.minAmplifier > 0) {
                return class_2561.method_43469((String)ClayPredicates.EFFECT_PREDICATE_DURATION_AMPLIFIER_COMPONENT, (Object[])new Object[]{this.effect().method_5560(), this.minDuration * 20, this.minAmplifier});
            }
            if (this.minAmplifier > 0) {
                return class_2561.method_43469((String)ClayPredicates.EFFECT_PREDICATE_AMPLIFIER_COMPONENT, (Object[])new Object[]{this.effect().method_5560(), this.minAmplifier});
            }
            if (this.minDuration > 0) {
                return class_2561.method_43469((String)ClayPredicates.EFFECT_PREDICATE_DURATION_COMPONENT, (Object[])new Object[]{this.effect().method_5560(), this.minDuration * 20});
            }
            return class_2561.method_43469((String)ClayPredicates.EFFECT_PREDICATE_COMPONENT, (Object[])new Object[]{this.effect().method_5560()});
        }
    }

    public static class SoldierPropertyPredicate
    extends ClayPredicate<SoldierPropertyPredicate> {
        public static final Codec<SoldierPropertyPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)PropertyTestType.CODEC.optionalFieldOf("test_type", (Object)PropertyTestType.EXIST).forGetter(p -> p.testType), (App)SoldierPropertyTypes.CODEC.fieldOf("property").forGetter(p -> p.propertyIdentifier), (App)Codec.INT.optionalFieldOf("value", (Object)-1).forGetter(p -> p.countNeeded)).apply((Applicative)in, SoldierPropertyPredicate::new));
        public static final class_9139<class_9129, SoldierPropertyPredicate> STREAM_CODEC = class_9139.method_56436(PropertyTestType.STREAM_CODEC, s -> s.testType, SoldierPropertyTypes.STREAM_CODEC, s -> s.propertyIdentifier, (class_9139)class_9135.field_48550, s -> s.countNeeded, SoldierPropertyPredicate::new);
        private final SoldierPropertyType<?> propertyIdentifier;
        private final PropertyTestType testType;
        private final int countNeeded;

        private SoldierPropertyPredicate(PropertyTestType testType, SoldierPropertyType<?> propertyIdentifier, int count) {
            super(SOLDIER_HOLDABLE_PROPERTY_PREDICATE);
            this.propertyIdentifier = propertyIdentifier;
            this.testType = testType;
            this.countNeeded = count;
        }

        public SoldierPropertyPredicate(PropertyTestType testType, SoldierPropertyType<?> propertyIdentifier) {
            this(testType, propertyIdentifier, -1);
        }

        public static SoldierPropertyPredicate getCount(SoldierPropertyType<Collection<?>> propertyIdentifier, int count) {
            return new SoldierPropertyPredicate(PropertyTestType.COUNT, propertyIdentifier, count);
        }

        public static SoldierPropertyPredicate isExactly(SoldierPropertyType<?> propertyIdentifier, int toBe) {
            return new SoldierPropertyPredicate(PropertyTestType.IS_EXACTLY, propertyIdentifier, toBe);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.LOW;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            int value = soldier.allProperties().getPropertyValueAsInt(this.propertyIdentifier);
            if (this.propertyIdentifier == SoldierPropertyTypes.ATTACK_TYPE.get() && value == AttackTypeProperty.NORMAL.ordinal()) {
                value = soldier.getAttackType().ordinal();
            }
            return this.testType.test(value, this.countNeeded);
        }

        @Override
        public class_2561 getDisplayName() {
            return this.testType.getDisplayName(this.propertyIdentifier.getDisplayName(), this.countNeeded);
        }
    }

    public static class LogicPredicate
    extends ClayPredicate<LogicPredicate> {
        public static final Codec<LogicPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)LogicComparator.CODEC.fieldOf("operation").forGetter(LogicPredicate::getComparator), (App)CodecUtils.singularOrPluralCodecOptional(ClayPredicate.CODEC, "predicate").forGetter(LogicPredicate::getList)).apply((Applicative)in, LogicPredicate::new));
        public static final class_9139<class_9129, LogicPredicate> STREAM_CODEC = class_9139.method_56435(LogicComparator.STREAM_CODEC, LogicPredicate::getComparator, (class_9139)ClayPredicate.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), s -> s.list, LogicPredicate::new);
        private final Set<ClayPredicate<?>> list;
        private final LogicComparator comparator;

        private LogicPredicate(LogicComparator comparator, Set<ClayPredicate<?>> list) {
            super(LOGIC_PREDICATE_SERIALIZER);
            this.list = list;
            this.comparator = comparator;
        }

        private Set<ClayPredicate<?>> getList() {
            return this.list;
        }

        private LogicComparator getComparator() {
            return this.comparator;
        }

        public static LogicPredicate any(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.ANY, predicates);
        }

        public static LogicPredicate all(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.ALL, predicates);
        }

        public static LogicPredicate none(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.NONE, predicates);
        }

        public static LogicPredicate not(ClayPredicate<?> predicates) {
            return new LogicPredicate(LogicComparator.NOT, Set.of(predicates));
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.MULTI;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            return this.comparator.test(this.list.stream().map(p -> p.test(soldier)).toList());
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            class_5250 mutableComponent = this.comparator.getDisplayName().method_27661().method_27692(class_124.field_1063);
            List<class_2561> components = this.list.stream().map(ClayPredicate::getDisplayName).filter(Objects::nonNull).toList();
            for (int i = 0; i < components.size(); ++i) {
                if (i == 0) {
                    mutableComponent.method_27693(" ");
                } else {
                    mutableComponent.method_27693(", ");
                }
                mutableComponent.method_10852(components.get(i));
            }
            return components.isEmpty() ? null : mutableComponent;
        }

        public String toString() {
            return "LogicPredicate(%s: %s)".formatted(this.comparator.serializedName, this.list);
        }
    }

    public static class ItemPredicate
    extends ClayPredicate<ItemPredicate> {
        private static final Codec<Either<ItemPredicateSlot, SoldierEquipmentSlot>> CODEC_SLOT = Codec.either(ItemPredicateSlot.CODEC, SoldierEquipmentSlot.CODEC);
        public static final Codec<ItemPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_7923.field_41178.method_39673().fieldOf("item").forGetter(ItemPredicate::getItem), (App)CODEC_SLOT.fieldOf("slot").forGetter(ItemPredicate::getSlot)).apply((Applicative)in, ItemPredicate::new));
        public static final class_9139<class_9129, ItemPredicate> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), ItemPredicate::getItem, (class_9139)class_9135.method_57995(ItemPredicateSlot.STREAM_CODEC, SoldierEquipmentSlot.STREAM_CODEC), ItemPredicate::getSlot, ItemPredicate::new);
        private final class_1792 item;
        private final SoldierEquipmentSlot slot;
        @Nullable
        private final ItemPredicateSlot specialSlot;

        private ItemPredicate(class_1792 item, Either<ItemPredicateSlot, SoldierEquipmentSlot> either) {
            super(ITEM_SERIALIZER);
            this.item = item;
            if (either.left().isPresent()) {
                this.specialSlot = (ItemPredicateSlot)either.left().get();
                this.slot = null;
            } else {
                this.slot = (SoldierEquipmentSlot)either.right().orElseThrow();
                this.specialSlot = null;
            }
        }

        public ItemPredicate(class_1792 item, SoldierEquipmentSlot slot) {
            this(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.right((Object)slot));
        }

        public static ItemPredicate any(class_1792 item) {
            return new ItemPredicate(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.left((Object)ItemPredicateSlot.ANY_SLOT));
        }

        public static ItemPredicate suitable(class_1792 item) {
            return new ItemPredicate(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.left((Object)ItemPredicateSlot.SUITABLE));
        }

        private Either<ItemPredicateSlot, SoldierEquipmentSlot> getSlot() {
            return this.slot != null ? Either.right((Object)this.slot) : Either.left((Object)this.specialSlot);
        }

        public class_1792 getItem() {
            return this.item;
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            if (this.slot == null) {
                assert (this.specialSlot != null);
                return class_2561.method_43469((String)ClayPredicates.ITEM_PREDICATE_ANY_COMPONENT, (Object[])new Object[]{this.item.method_7848(), this.specialSlot.getDisplayName()}).method_27692(class_124.field_1063);
            }
            return class_2561.method_43469((String)ClayPredicates.ITEM_PREDICATE_COMPONENT, (Object[])new Object[]{this.item.method_7848(), this.slot.getDisplayName()}).method_27692(class_124.field_1063);
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            if (this.slot != null) {
                return soldier.getItemBySlot(this.slot).stack().method_31574(this.item);
            }
            if (this.specialSlot == ItemPredicateSlot.ANY_SLOT) {
                for (class_1799 stack : soldier.method_56675()) {
                    if (!stack.method_31574(this.item)) continue;
                    return true;
                }
                return false;
            }
            SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(this.item);
            if (effect != null) {
                for (SoldierEquipmentSlot possibleSlot : effect.slots()) {
                    if (!soldier.getItemBySlot(possibleSlot).stack().method_7960()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum LogicComparator implements class_3542
    {
        ANY("any", list -> list.contains(true)),
        ALL("all", list -> !list.contains(false)),
        NONE("none", list -> !list.contains(true)),
        NOT("not", list -> (Boolean)list.getFirst() == false);

        public static final class_3542.class_8808<LogicComparator> CODEC;
        private static final class_9139<class_2540, LogicComparator> STREAM_CODEC;
        private final String serializedName;
        private final Predicate<List<Boolean>> predicate;

        private LogicComparator(String name, Predicate<List<Boolean>> predicate) {
            this.serializedName = name;
            this.predicate = predicate;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("clay_soldier_predicate.csr.logic_comparator." + this.serializedName));
        }

        @NotNull
        public String method_15434() {
            return this.serializedName;
        }

        public boolean test(List<Boolean> list) {
            return this.predicate.test(list);
        }

        static {
            CODEC = class_3542.method_28140(LogicComparator::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(LogicComparator.class);
        }
    }

    public static enum PropertyTestType implements class_3542
    {
        INCREASE("increase", i -> i > 0),
        DECREASE("decrease", i -> i < 0),
        EXIST("exist", i -> i != 0),
        IS_EXACTLY("exactly", (n, c) -> n == c),
        COUNT("count", (n, c) -> n >= c);

        public static final Codec<PropertyTestType> CODEC;
        private static final class_9139<class_2540, PropertyTestType> STREAM_CODEC;
        private final String serializedName;
        private final BiIntPredicate predicate;

        private PropertyTestType(String serializedName, BiIntPredicate predicate) {
            this.serializedName = serializedName;
            this.predicate = predicate;
        }

        private PropertyTestType(String serializedName, IntPredicate predicate) {
            this(serializedName, (int number, int ignored) -> predicate.test(number));
        }

        public class_2561 getDisplayName(class_2561 propertyName, int count) {
            return class_2561.method_43469((String)this.getDescriptionId(), (Object[])new Object[]{propertyName, "" + count}).method_27692(class_124.field_1063);
        }

        public String getDescriptionId() {
            return "clay_soldier_predicate.csr..property_test_type." + this.serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        public boolean test(int number, int shouldBe) {
            return this.predicate.test(number, shouldBe);
        }

        static {
            CODEC = class_3542.method_28140(PropertyTestType::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(PropertyTestType.class);
        }

        @FunctionalInterface
        private static interface BiIntPredicate {
            public boolean test(int var1, int var2);
        }
    }

    public static enum ItemPredicateSlot implements class_3542,
    KeyableTranslatableProperty
    {
        ANY_SLOT("any"),
        SUITABLE("suitable");

        private static final String ITEM_PREDICATE_SPECIAL = "clay_soldier_predicate.csr.item_predicate_special.any.";
        private static final Codec<ItemPredicateSlot> CODEC;
        private static final class_9139<class_2540, ItemPredicateSlot> STREAM_CODEC;
        private final String serializedName;

        private ItemPredicateSlot(String serializedName) {
            this.serializedName = serializedName;
        }

        @Override
        public String translatableKey() {
            return ITEM_PREDICATE_SPECIAL + this.serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(ItemPredicateSlot::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(ItemPredicateSlot.class);
        }
    }
}

