/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.bumblebee.claysoldiers.commands.DefaultedResourceLocationArgument;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.ClaySoldierBossEquipment;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.soldieritemtypes.SoldierItemType;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class ClaySoldierCommands {
    public static final String COMMAND_TEAM_SINGLE_SUCCESS = "commands.csr.change_team.success.single";
    public static final String COMMAND_TEAM_MULTIPLE_SUCCESS = "commands.csr.change_team.success.multiple";
    public static final String COMMAND_TEAM_FAILURE = "commands.csr.change_team.failure";
    public static final String COMMAND_TEAM_ITEM_SUCCESS = "commands.csr.change_team.item.success";
    public static final String COMMAND_EXECUTED_BY_PLAYER = "commands.csr.change_team.item.failure";
    public static final String COMMAND_LOADED_TEAMS_SUCCESS = "commands.csr.loaded_teams";
    public static final String COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS = "commands.csr.team_allegiance";
    public static final String COMMAND_SHOW_TEAM_ALLEGIANCE_EMPTY = "commands.csr.team_allegiance.empty";
    public static final String COMMAND_ITEM_SET_ERROR = "commands.csr.spawn_item_set.error";
    public static final String COMMAND_ITEM_SET_FAILURE = "commands.csr.spawn_item_set.failure";
    public static final String COMMAND_TEAM_LOYALTY_FAILURE = "commands.csr.team_loyalty.set.failure";
    public static final String COMMAND_TEAM_LOYALTY_REMOVE_FAILURE = "commands.csr.team_loyalty.remove.failure";
    public static final String COMMAND_TEAM_LOYALTY_REMOVE = "commands.csr.team_loyalty.remove.success";
    public static final String COMMAND_TEAM_LOYALTY_SET = "commands.csr.team_loyalty.set.success";
    public static final String ENABLING_DATAPACK = "commands.csr.datapack.enabling";
    public static final String DISABLING_DATAPACK = "commands.csr.datapack.disabing";

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        LiteralArgumentBuilder csrCommand = class_2170.method_9247((String)"csr");
        csrCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"items").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"set", (ArgumentType)DefaultedResourceLocationArgument.itemType(context)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> ClaySoldierCommands.spawnItems((CommandContext<class_2168>)c, true))).then(class_2170.method_9247((String)"uniform").executes(c -> ClaySoldierCommands.spawnItems((CommandContext<class_2168>)c, false))))));
        csrCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"team").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(c -> c.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(ClaySoldierCommands::setTeamCommand)))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(ClaySoldierCommands::setTeamHandCommand))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"loyalty").requires(c -> c.method_9259(0))).executes(ClaySoldierCommands::showTeamAllegiance)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(c -> c.method_9259(4))).then(class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> ClaySoldierCommands.setTeamLoyalty((CommandContext<class_2168>)c, (class_1657)class_2186.method_9315((CommandContext)c, (String)"player"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(c -> c.method_9259(4))).then(class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.setTeamLoyalty((CommandContext<class_2168>)c, null))))));
        csrCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"boss").requires(c -> c.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"normal").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.NORMAL, 0, null, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.NORMAL, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), false))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.NORMAL, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), true))))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.NORMAL, 0, null, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vampire").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.VAMPIRE, 0, null, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.VAMPIRE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), false))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.VAMPIRE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), true))))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.VAMPIRE, 0, null, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"zombie").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.ZOMBIE, 0, null, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.ZOMBIE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), false))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.ZOMBIE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<class_2168>)c), true))))).then(class_2170.method_9247((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.ZOMBIE, 0, null, true))))).then(class_2170.method_9247((String)"random").then(class_2170.method_9244((String)"weight", (ArgumentType)IntegerArgumentType.integer((int)0, (int)25)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<class_2168>)c, ClaySoldierBossEquipment.RANDOM, IntegerArgumentType.getInteger((CommandContext)c, (String)"weight"), null, false)))));
        dispatcher.register(csrCommand);
    }

    private static int spawnItems(CommandContext<class_2168> command, boolean random) {
        class_2168 source = (class_2168)command.getSource();
        SoldierItemType type = (SoldierItemType)((class_2168)command.getSource()).method_30497().method_30530(ModRegistries.SOLDIER_ITEM_TYPES).method_10223((class_2960)command.getArgument("set", class_2960.class));
        if (type == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)COMMAND_ITEM_SET_ERROR));
            return -1;
        }
        int count = IntegerArgumentType.getInteger(command, (String)"amount");
        class_243 pos = source.method_9222();
        class_5819 randomSource = random ? source.method_9225().method_8409() : class_5819.method_43049((long)42L);
        class_2371<class_1799> list = type.getItems(randomSource, count);
        if (list.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)COMMAND_ITEM_SET_FAILURE));
            return -1;
        }
        list.forEach(itemStack -> ClaySoldierCommands.dropDelayedItemStack((class_1937)source.method_9225(), pos.field_1352, pos.field_1351, pos.field_1350, itemStack));
        source.method_9226(type::getDisplayName, true);
        return 1;
    }

    private static void dropDelayedItemStack(class_1937 level, double x, double y, double z, class_1799 stack) {
        double width = class_1299.field_6052.method_17685();
        double d1 = 1.0 - width;
        double d2 = width / 2.0;
        double d3 = Math.floor(x) + level.field_9229.method_43058() * d1 + d2;
        double d4 = Math.floor(y) + level.field_9229.method_43058() * d1;
        double d5 = Math.floor(z) + level.field_9229.method_43058() * d1 + d2;
        while (!stack.method_7960()) {
            class_1542 itementity = new class_1542(level, d3, d4, d5, stack.method_7971(level.field_9229.method_43048(21) + 10));
            itementity.method_18800(level.field_9229.method_43385(0.0, 0.11485000171139836), level.field_9229.method_43385(0.2, 0.11485000171139836), level.field_9229.method_43385(0.0, 0.11485000171139836));
            itementity.method_6982(60);
            level.method_8649((class_1297)itementity);
        }
    }

    private static int setTeamCommand(CommandContext<class_2168> command) throws CommandSyntaxException {
        List<ClayMobTeamOwnerEntity> entities = class_2186.method_9317(command, (String)"targets").stream().filter(ClayMobTeamOwnerEntity.class::isInstance).map(ClayMobTeamOwnerEntity.class::cast).toList();
        class_5455 registries = ((class_2168)command.getSource()).method_30497();
        class_2960 team = DefaultedResourceLocationArgument.key("team", command);
        for (ClayMobTeamOwnerEntity entity : entities) {
            entity.setClayTeamType(team);
        }
        if (entities.size() == 1) {
            ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_TEAM_SINGLE_SUCCESS, (Object[])new Object[]{ClayMobTeamManger.getFromKeyAssumeValid(team, registries).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        } else if (entities.size() > 1) {
            ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_TEAM_MULTIPLE_SUCCESS, (Object[])new Object[]{entities.size(), ClayMobTeamManger.getFromKeyAssumeValid(team, registries).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        } else {
            ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43471((String)COMMAND_TEAM_FAILURE));
        }
        return entities.size();
    }

    private static int setTeamLoyalty(CommandContext<class_2168> command, @Nullable class_1657 player) {
        class_2960 teamId = DefaultedResourceLocationArgument.key("team", command);
        class_2561 team = ClayMobTeamManger.getFromKeyOrError(teamId, (class_7225.class_7874)((class_2168)command.getSource()).method_30497()).getDisplayNameWithColor(ColorHelper::getColorStatic);
        if (TeamLoyaltyManger.setTeamPlayer(((class_2168)command.getSource()).method_9225(), teamId, player)) {
            if (player == null) {
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_TEAM_LOYALTY_REMOVE, (Object[])new Object[]{team}), true);
            } else {
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_TEAM_LOYALTY_SET, (Object[])new Object[]{team, player.method_5476()}), true);
            }
            return 1;
        }
        if (player == null) {
            ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43469((String)COMMAND_TEAM_LOYALTY_REMOVE_FAILURE, (Object[])new Object[]{team}));
        } else {
            ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43469((String)COMMAND_TEAM_LOYALTY_FAILURE, (Object[])new Object[]{team, player.method_5476()}));
        }
        return -1;
    }

    private static int setTeamHandCommand(CommandContext<class_2168> command) {
        class_2960 team = DefaultedResourceLocationArgument.key("team", command);
        class_3222 player = ((class_2168)command.getSource()).method_44023();
        if (player == null) {
            ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43471((String)COMMAND_EXECUTED_BY_PLAYER));
            return -1;
        }
        int set = -1;
        class_1799 mainHand = player.method_5998(class_1268.field_5808);
        class_1799 offHand = player.method_5998(class_1268.field_5810);
        if (ClaySoldierCommands.itemIsClayDoll(mainHand)) {
            ClaySoldierSpawnItem.setClayMobTeam(mainHand, team, (class_7225.class_7874)((class_2168)command.getSource()).method_30497());
            set = 1;
        }
        if (ClaySoldierCommands.itemIsClayDoll(offHand)) {
            ClaySoldierSpawnItem.setClayMobTeam(offHand, team, (class_7225.class_7874)((class_2168)command.getSource()).method_30497());
            set = set == -1 ? 1 : 2;
        }
        ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_TEAM_ITEM_SUCCESS, (Object[])new Object[]{ClayMobTeamManger.getFromKeyAssumeValid(team, ((class_2168)command.getSource()).method_30497()).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        return set;
    }

    private static boolean itemIsClayDoll(class_1799 stack) {
        return stack.method_31574(ModItems.CLAY_SOLDIER.method_8389());
    }

    private static int summonBossClaySoldier(CommandContext<class_2168> command, ClaySoldierBossEquipment equipment, int weight, @Nullable class_2960 team, boolean waxed) {
        BossClaySoldierEntity boss = (BossClaySoldierEntity)ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get().method_5883((class_1937)((class_2168)command.getSource()).method_9225());
        if (boss == null) {
            return -1;
        }
        boss.method_29495(((class_2168)command.getSource()).method_9222());
        equipment.setUp(boss, weight, team, waxed);
        ((class_2168)command.getSource()).method_9225().method_8649((class_1297)boss);
        return 1;
    }

    private static int showTeamAllegiance(CommandContext<class_2168> command) {
        class_3218 level = ((class_2168)command.getSource()).method_9225();
        Counter counter = new Counter();
        TeamPlayerData teamDataMap = TeamLoyaltyManger.getTeamPlayerData(level);
        teamDataMap.forEach((team, playerData) -> {
            class_1657 player = level.method_18470(playerData.getUUID());
            class_2561 teamName = ClayMobTeamManger.getFromKeyAssumeValid(team, ((class_2168)command.getSource()).method_30497()).getDisplayNameWithColor(ColorHelper::getColorStatic);
            counter.add();
            if (player != null) {
                teamDataMap.updatePlayerName((class_2960)team, player);
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS, (Object[])new Object[]{teamName, player.method_5476()}), false);
            } else {
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS, (Object[])new Object[]{teamName, playerData.getLastDisplayName()}), false);
            }
        });
        if (counter.count == 0) {
            ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43471((String)COMMAND_SHOW_TEAM_ALLEGIANCE_EMPTY), false);
        }
        return counter.count - 1;
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }

        private void add() {
            ++this.count;
        }
    }
}

